# prompt template for alice
# will be imported by alice_feedback.py

# prompt template for alice
# will be imported by alice_feedback.py

class PromptTemplate:
    def __init__(self):

        self.no_persona_prompt = """You are a web-shop-agent that can interact with the given shopping webpage by taking actions and finally buy something that you want. You can freely take any action and buy anything that you think is appropriate and interesting."""

        self.system_prompt = """Your actions are strictly limited to two types:

            1. search[keywords]: Use this action when only a "[ Search ]" button is present in the page content. You must replace "keywords" with any valid search query you want to search.

            2. click[HTML Element]: Use this action to click on HTML Element in the page content. "HTML Element" can be any clickable element in the page represented inside "[" and "]", such as a item id, or action button. Please note that item id or action name must be present in the page content.

You must take only one action among the above two types."""

        self.persona = '''You are a web-shop-agent that can interact with the webpage by taking actions. You need to buy something that you want at the end. Also, you must adopt the identity of following persona :\n            "{persona_instance}" \nYou should take actions that are consistent with the persona you have adopted.\n'''

        self.instruction_feedback_prompt = '''\n\nWhen generating an action, please refer to both success and failure instructions. You need to create an action sequence that are different from the success cases and similar for the failure instructions, so that we can have more exploration results for improvement.

       Example Instructions:

        **Success Instructions:**  
        - Example 1:\n{random_success_instructions[0]}\n  
        - Example 2:\n{random_success_instructions[1]}\n  

        **Failure Instructions:**  
        - Example 3:\n{random_fail_instructions[0]}\n  
        - Example 4:\n{random_fail_instructions[1]}\n  

        Your should involve adapting and improving interactions by combining insights from both success and failure cases, but always exploring new ways to overcome failure points.'''


        self.action_feedback_prompt = '''\n\nWhen generating an action, please refer to both success and failure action sequences. You need to explore actions that are different from the success cases and similar to the failure action sequences, so that we can have more exploration results for improvement. But do not simply repeat the success or failure action sequences.

        ### Example Action Sequences:

        **Success Action Sequence:**  
        - Example 1:\n{random_success_actions[0]}\n  
        - Example 2:\n{random_success_actions[1]}\n  
        - Example 1:\n{random_success_actions[2]}\n  
        - Example 2:\n{random_success_actions[3]}\n  

        **Failure Action Sequence:**  
        - Example 3:\n{random_fail_actions[0]}\n  
        - Example 4:\n{random_fail_actions[1]}\n  
        - Example 3:\n{random_fail_actions[2]}\n  
        - Example 4:\n{random_fail_actions[3]}\n  

        You should involve adapting and improving interactions by combining insights from both success and failure cases.'''

        self.summary_prompt = '''\n\nHere is an important feedback from the previous round:

        {summary}

        Please consider the feedback during your free exploration.'''

    def call_feedback_prompt(self, random_success_cases, random_fail_cases):
        return self.action_feedback_prompt.format(
            random_success_actions=random_success_cases,
            random_fail_actions=random_fail_cases
        )
    
    def call_instruction_feedback_prompt(self, random_success_cases, random_fail_cases):
        return self.instruction_feedback_prompt.format(
            random_success_instructions=random_success_cases,
            random_fail_instructions=random_fail_cases
        )
    
    def call_persona_prompt(self, persona_instance):
        return self.persona.format(persona_instance=persona_instance)

    def call_summary_prompt(self, summary):
        return self.summary_prompt.format(summary=summary)
