#!/bin/bash

# GPU Configuration
export CUDA_VISIBLE_DEVICES=0  # Modify this as needed

# Model Configuration
MODEL="Qwen/Qwen2.5-7B-Instruct"  # Base model path

# Output Configuration
OUTPUT_DIR="data/tasks"  # Directory for task output
OUTPUT_FILE="tasks_iter0.json"  # Output filename
OUTPUT_PATH="${OUTPUT_DIR}/${OUTPUT_FILE}"

# Optional: Path to LoRA checkpoint for task generation
LORA_PATH="finetuning/checkpoints/qwen_7b_iter0/checkpoint-400"  # Modify as needed

# Run Alice create tasks script
python alice_create_tasks.py \
    --output-path "${OUTPUT_PATH}" \
    --model-path "${MODEL}" \
    --num-tasks 1000 \
    --seed 42 \
    --overwrite \
    --lora-path "${LORA_PATH}" \
    --use-vllm \
    --save-rationale

    
