#!/bin/bash

# Configuration variables - modify these as needed
LORA_DIR="finetuning/checkpoints/qwen_7b_iter0/epoch_1"  # Path to LoRA checkpoint
MODEL_PATH="Qwen/Qwen2.5-7B-Instruct"  # Base model path
NUM_TASKS=500
REWARD_TYPE="rouge"
EXP_NAME="qwen_7b_iter0_eval"  # Experiment name
MODE="action"

# Environment configuration
export VLLM_WORKER_MULTIPROC_METHOD=spawn
export CUDA_VISIBLE_DEVICES=0  # Modify this as needed

# Run evaluation
python eval_bob.py \
    --model-path $MODEL_PATH \
    --num-tasks $NUM_TASKS \
    --exp-name $EXP_NAME \
    --add-CoT \
    --mode $MODE \
    --use-vllm


