#!/bin/bash

# Configuration variables - modify these as needed
CUSTOM_PATH="data/custom_tasks.json"  # Path to custom tasks file
MODEL_PATH="Qwen/Qwen2.5-7B-Instruct"  # Base model path
NUM_TASKS=500
REWARD_TYPE="rouge"
BASE_LORA_DIR="finetuning/checkpoints/qwen_7b_iter0"  # Base directory for LoRA checkpoints
EXP_BASE_NAME="qwen_7b_iter0"  # Base name for experiment
MODE="action"

# Add NUM_TASKS to the experiment name
EXP_BASE_NAME="${EXP_BASE_NAME}_${NUM_TASKS}"

# Set GPU device
export CUDA_VISIBLE_DEVICES=0  # Modify this as needed

# Loop through steps (100-wise step checkpoints)
for STEP in {400..500..100}; do  # Change the range as needed
    LORA_DIR="${BASE_LORA_DIR}/step_${STEP}"
    EXP_NAME="${EXP_BASE_NAME}_step_${STEP}"
    echo "Evaluating checkpoint at: $LORA_DIR"

    # Run validation evaluation
    python eval_bob.py \
        --model-path $MODEL_PATH \
        --num-tasks 50 \
        --exp-name $EXP_NAME \
        --add-CoT \
        --lora-dir $LORA_DIR \
        --validation \
        --use-vllm \
        --mode $MODE

    # Run full evaluation
    python eval_bob.py \
        --model-path $MODEL_PATH \
        --num-tasks $NUM_TASKS \
        --exp-name $EXP_NAME \
        --add-CoT \
        --lora-dir $LORA_DIR \
        --use-vllm \
        --mode $MODE
done