import gym

import gym
import random
import numpy as np


class EvalWrapper(gym.Wrapper):

    def __init__(
        self,
        env,
        task_name="",
        max_episode_steps=1000,
    ):
        super().__init__(env)
        self.task = task_name
        self._max_episode_steps = max_episode_steps
        self._elapsed_steps = 0
        self._view = self.env._view

    def reset(self, **kwargs):
        obs = self.env.reset(**kwargs)

        self._world = self.env._world
        self._player = self.env._player

        self._elapsed_steps = 0
        self._set_inventory_to_eval(self.task)
        return obs

    def step(self, action):
        self._elapsed_steps += 1
        obs, reward, done, info = self.env.step(action)
        self._step = self.env._step
        self._unlocked = self.env._unlocked

        if self._elapsed_steps >= self._max_episode_steps:
            done = True
        return obs, reward, done, info

    def _set_inventory_to_eval(self, task):
        # Initialize all items to 0
        inventory = {
            # status
            "health": 9,
            "food": 9,
            "drink": 9,
            "energy": 9,
            # material
            "sapling": 0,
            "wood": 0,
            "stone": 0,
            "coal": 0,
            "iron": 0,
            "diamond": 0,
            # tool
            "wood_pickaxe": 0,
            "stone_pickaxe": 0,
            "iron_pickaxe": 0,
            "wood_sword": 0,
            "stone_sword": 0,
            "iron_sword": 0,
        }

        # Define task-specific inventory requirements
        # TODO: should we add some random inventories that are not pre-requisites?
        task_requirements = {
            "place_table": {"wood": 2},
            "place_plant": {"sapling": 1},
            "place_furnace": {"stone": 4, "wood_pickaxe": 1},
            "place_stone": {"stone": 1},
            "collect_stone": {"wood_pickaxe": 1},
            "collect_coal": {"wood_pickaxe": 1},
            "collect_iron": {"wood_pickaxe": 1, "stone_pickaxe": 1},
            "collect_diamond": {"wood_pickaxe": 1, "stone_pickaxe": 1, "iron_pickaxe": 1},
            "make_wood_pickaxe": {"wood": 3},
            "make_wood_sword": {"wood": 3},
            "make_stone_pickaxe": {"wood": 3, "stone": 1, "wood_pickaxe": 1},
            "make_stone_sword": {"wood": 3, "stone": 1, "wood_pickaxe": 1},
            "make_iron_pickaxe": {"wood": 3, "stone": 5, "coal": 1, "iron": 1, "wood_pickaxe": 1, "stone_pickaxe": 1},
            "make_iron_sword": {"wood": 3, "stone": 5, "coal": 1, "iron": 1, "wood_pickaxe": 1, "stone_pickaxe": 1},
        }

        # Update inventory with task-specific requirements
        if task in task_requirements:
            inventory.update(task_requirements[task])

        self._player.inventory = inventory

    def render(self, size=None):
        return self.env.render(size)