#!/bin/bash

# GPU Configuration
export CUDA_VISIBLE_DEVICES=0  # Modify this as needed

# Model Configuration
MODEL_SIZE="7B"  # Model size (e.g., 7B, 14B)
MODEL_PATH="Qwen/Qwen2.5-7B-Instruct"  # Base model path

# Training Configuration
NUM_GPUS=1
BATCH_SIZE_PER_GPU=1
TOTAL_BATCH_SIZE=64
GRADIENT_ACC_STEPS=$(($TOTAL_BATCH_SIZE/$NUM_GPUS/$BATCH_SIZE_PER_GPU))

echo "Training Qwen model ${MODEL_SIZE} using $NUM_GPUS GPUs, $BATCH_SIZE_PER_GPU batch size per GPU, $GRADIENT_ACC_STEPS gradient accumulation steps"

# Optional: Path to previous LoRA checkpoint for continued training
# LORA_CHECKPOINT_PATH="checkpoints/previous_run/step_100"

# Data and Output Configuration
TRAIN_FILE="data/train.jsonl"  # Path to training data
OUTPUT_DIR="checkpoints/qwen_7b_iter1"  # Output directory for checkpoints

# Launch training with accelerate
accelerate launch \
    --mixed_precision bf16 \
    --main_process_port 29515 \
    --num_machines 1 \
    --num_processes $NUM_GPUS \
    --gpu_ids $CUDA_VISIBLE_DEVICES \
    --use_deepspeed \
    --deepspeed_config_file configs/ds_configs/stage3_no_offloading_accelerate.conf \
    open_instruct/finetune.py \
    --model_name_or_path $MODEL_PATH \
    --use_flash_attn \
    --tokenizer_name $MODEL_PATH \
    --use_slow_tokenizer \
    --train_file $TRAIN_FILE \
    --max_seq_length 2048 \
    --preprocessing_num_workers 4 \
    --per_device_train_batch_size $BATCH_SIZE_PER_GPU \
    --gradient_accumulation_steps $GRADIENT_ACC_STEPS \
    --learning_rate 2e-5 \
    --lr_scheduler_type linear \
    --max_train_steps 300 \
    --output_dir $OUTPUT_DIR \
    --with_tracking \
    --report_to tensorboard \
    --logging_steps 1 \
    --use_lora \
    --checkpointing_steps "50"
    # Uncomment to continue from a previous checkpoint:
    # --lora_checkpoint_path $LORA_CHECKPOINT_PATH
