#!/bin/bash

# GPU Configuration
export CUDA_VISIBLE_DEVICES=0  # Modify this as needed

# Model Configuration
MODEL="Qwen/Qwen2.5-7B-Instruct"  # Base model path

# Output Configuration
OUTPUT_DIR="data/feedback"  # Directory for feedback output
OUTPUT_FILE="feedback_iter1.json"  # Output filename
OUTPUT_PATH="${OUTPUT_DIR}/${OUTPUT_FILE}"

# Data Configuration
EVAL_PATH="results/validation/results_iter0.json"  # Path to evaluation results
DATA_FILE="data/tasks/iter0_tasks.json"  # Optional: Path to input data file

# Run Alice feedback script
python alice_feedback.py \
    --output-path "${OUTPUT_PATH}" \
    --eval-file "${EVAL_PATH}" \
    --num-tasks 5 \
    --seed 21 \
    --save-rationale \
    --overwrite \
    --model-path "${MODEL}" \
    --use-summary \
    --use-vllm \
    --two-history
    # Uncomment to use custom data file:
    # --data-file "${DATA_FILE}"
