import math
import time
from interbotix_xs_modules.locobot import InterbotixLocobotXS
import time
# rospy for the subscriber
import rospy
# ROS Image message
# from sensor_msgs.msg import Image
# ROS Image message -> OpenCV2 image converter
from cv_bridge import CvBridge
# OpenCV2 for saving an image
import cv2
import numpy as np
import pyrealsense2 as rs

from PIL import Image

from  locobot_env.resources.motor import Motor

class LoCoBotInterface():
    # Constructor and move arm to resting position
    def __init__(self):
        print("THIS INTERFACE H")
        self.locobot = InterbotixLocobotXS(robot_model="locobot_wx200", arm_model="mobile_wx200")
        
        self.current_pos = [0, 0]
        self.even = True

        ctx = rs.context()
        devices = ctx.query_devices()
        for dev in devices:
            dev.hardware_reset()

        self.pipe = rs.pipeline()
        self.profile = self.pipe.start()
        self.camera_image = 0

        self.relative_moving_time = 0.25
        self.current_pos = [4, 6] # level from 0 to 4. angle from 0 to 8


    def go_rest(self):
        A = [0.13345633447170258, 0.36968937516212463, 0.3221359848976135, 0.5890486240386963, -2.8255927562713623]
        B = [0.06902913749217987, -0.31446605920791626, 1.0339031219482422, 0.8084079027175903, -2.8255927562713623]
        self.locobot.arm.set_joint_positions(A, moving_time=2)
        self.locobot.arm.set_joint_positions(B, moving_time=1)

    # Define resting position as right in front of base of arm
    def go_start(self):
        A = [-0.20555342733860016, 0.6841554641723633, -0.12271846830844879, 0.951068103313446, -2.8440005779266357]
        B = [-0.1902136206626892, 0.8958448171615601, -0.08436894416809082, 0.5506991147994995, -2.8271267414093018]
        # A = [0.19788353145122528, 0.7056311964988708, -0.21935926377773285, 1.0477088689804077, -2.8363306522369385]
        # B = [0.19788353145122528, 0.9694758653640747, -0.2791845202445984, 0.8114758729934692, -2.8424665927886963]
        self.locobot.arm.set_joint_positions(A, moving_time=1)
        self.locobot.arm.set_joint_positions(B, moving_time=self.relative_moving_time)
        self.current_pos = [4, 6]


    def clear_front(self):
        above = np.array([0.9357283115386963, 0.11198060214519501, 0.9265244007110596, 0.5491651296615601, -2.063204288482666])
        start = np.array([0.8682331442832947, 0.5675728917121887, 0.6826214790344238, 0.35128161311149597, -1.9849711656570435])
        middle = np.array([0.4862719178199768, 0.5905826091766357, 0.5046796798706055, 0.28378644585609436, -2.6798644065856934])
        end = np.array([0.30833014845848083, 0.9924855828285217, -0.45405831933021545, 0.7608544826507568, -2.824058771133423])
        up = np.array([0.3635534644126892, 0.4832039475440979, -0.17487381398677826, 0.9081166386604309, -2.824058771133423])

        self.locobot.arm.set_joint_positions(above, moving_time = 1)
        self.locobot.arm.set_joint_positions(start, moving_time = 0.5)
        self.locobot.arm.set_joint_positions(middle, moving_time = 0.5)
        self.locobot.arm.set_joint_positions(end, moving_time = 0.5)

        self.locobot.arm.set_joint_positions(up, moving_time = 1)

    def clear_back(self):
        above = np.array([0.3905437469482422, 0.9234564304351807, -0.7593204975128174, 1.2087769508361816, -2.994330644607544])
        start = np.array([0.3904854941368103, 1.3268934488296509, -1.1290098428726196, 1.5968739986419678, -2.8501362800598145])
        middle = np.array([0.5092816352844238, 0.8620972037315369, -0.058291271328926086, 1.0753206014633179, -2.7304859161376953])
        end = np.array([1.009359359741211, 0.5645049214363098, 0.7992039918899536, 0.33133986592292786, -2.393010139465332])
        up = np.array([0.8406214714050293, 0.0015339808305725455, 1.0108933448791504, 0.4555923044681549, -2.4497673511505127])

        self.locobot.arm.set_joint_positions(above, moving_time = 1)
        self.locobot.arm.set_joint_positions(start, moving_time = 0.5)
        self.locobot.arm.set_joint_positions(middle, moving_time = 0.5)
        self.locobot.arm.set_joint_positions(end, moving_time = 0.5)

        self.locobot.arm.set_joint_positions(up, moving_time = 1)
    

    def reset(self):
        if self.even:
            self.clear_front()
        else:
            self.clear_back()

        self.even = not self.even

        self.go_rest()

    def step(self, action):
        pos = self.current_pos

        if action == 0:
            return
        if action == 1:
            if pos[0] == 4:
                return
            if pos[0] == 0 and (pos[1] == 0 or pos[1] == 8):
                return
            if pos[0] == 2 and (pos[1] == 1 or pos[1] == 7):
                return 
            
            self.move_forward()
            return
        if action == 2:
            if pos[0] == 0:
                return
            self.move_backwards()
            return
        if action == 3:
            if pos[1] == 8:
                return
            if pos[1] == 7 and pos[0] > 0:
                return
            if pos[1] == 6 and pos[0] > 2:
                return
            self.rotate_cw()
            return
        if action == 4:
            if pos[1] == 0:
                return
            if pos[1] == 1 and pos[0] > 0:
                return
            if pos[1] == 2 and pos[0] > 2:
                return
            self.rotate_ccw()
            return
        

    # Use pyrealsense2 to get an image from the camera
    def get_image(self):
        frames = self.pipe.wait_for_frames()
        color_frame = frames.get_color_frame() 

        rgb = np.array(color_frame.get_data())

        return rgb
    
    # Use numpy to convert cv2 image into a more usable image by
    # modifying bounds, rotating the image and converting the image to an RGB array
    def get_image_rgb(self) :
        rgb = self.get_image()[130:300, 210:430]
        rgb = np.rot90(rgb, 1)

        return rgb
    
   
    # Move the end effector away from the base by some small amount
    def move_backwards(self):
        self.locobot.arm.set_ee_cartesian_trajectory(x = -0.04, moving_time = self.relative_moving_time)
        self.current_pos[0] -= 1

    # Move the end effector towards the base by some small amount
    def move_forward(self):
        self.locobot.arm.set_ee_cartesian_trajectory(x = 0.04, moving_time = self.relative_moving_time)
        self.current_pos[0] += 1

    # Rotate the arm clockwise by some small amount
    def rotate_cw(self):
        # moves 0.26 rad = 15 deg
        current_angle = self.locobot.arm.get_single_joint_command("waist")
        self.locobot.arm.set_single_joint_position("waist", current_angle - 2 * math.pi/60.0, moving_time = self.relative_moving_time)
        self.current_pos[1] += 1

    # Rotate the arm counterclockwise by some small amount
    def rotate_ccw(self):
        # moves 0.26 rad = 15 deg
        current_angle = self.locobot.arm.get_single_joint_command("waist")
        self.locobot.arm.set_single_joint_position("waist", current_angle + 2 * math.pi/60.0, moving_time = self.relative_moving_time)
        self.current_pos[1] -= 1
