#!/bin/bash
n_simulations=(1000 10000 100000)
n_epochs=(2000 1000 500)

for i in ${!n_simulations[@]}; do
  echo "python run_sbi.py --dataset sbi_two_moons --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.025 --n_simulations ${n_simulations[$i]}"
  echo "python run_sbi.py --dataset sbi_bernoulli_glm --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.01 --n_simulations ${n_simulations[$i]}"
  echo "python run_sbi.py --dataset sbi_bernoulli_glm_raw --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.01  --n_simulations ${n_simulations[$i]}"
  echo "python run_sbi.py --dataset sbi_gaussian_mixture --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.025 --n_simulations ${n_simulations[$i]}"
  echo "python run_sbi.py --dataset sbi_gaussian_linear --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.01 --n_simulations ${n_simulations[$i]}"
  echo "python run_sbi.py --dataset sbi_gaussian_linear_uniform --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.01  --n_simulations ${n_simulations[$i]}"
  echo "python run_sbi.py --dataset sbi_slcp --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.25 --n_simulations ${n_simulations[$i]} --n_base_means 4 --normalize_sbi_data"
  echo "python run_sbi.py --dataset sbi_slcp_distractors --keep_datapoints --n_epochs ${n_epochs[$i]} --fourier_sigma 0.01 --n_simulations ${n_simulations[$i]} --n_base_means 4 --normalize_sbi_data"
done
