#!/bin/bash
n_points=(100 200 500 1000)
n_epochs=5000
datasets=("mog --n_mog 10 --mog_sigma 0.1" "two_moons" "pinwheel" "swiss_roll" "checkerboard")
n_means=(20 2 10 20 20)
seeds=(1 2 3 4 5)

for s in "${seeds[@]}"; do
  for n in "${n_points[@]}"; do
    for i in "${!datasets[@]}"; do
      echo "uv run synthetic_log_lik.py --dataset ${datasets[$i]} --base_distribution mog --n_base_means ${n_means[$i]} --keep_datapoints --n_epochs ${n_epochs} --n_samples_dataset ${n} --n_samples_dataset_test ${n} --n_val_steps 100 --seed ${s}"
    done
  done
done
