#!/bin/bash
n_points=(100 500 1000 5000)
n_epochs=5000
datasets=("line" "sin" "spiral" "circle")
seeds=(1 2 3 4 5)

for s in "${seeds[@]}"; do
  for n in "${n_points[@]}"; do
    for i in "${!datasets[@]}"; do
      echo "uv run synthetic_log_lik.py --dataset mog_manifold --n_mog 200 --mog_sigma 0.2 --manifold_type ${datasets[$i]} --base_distribution uniform --manifold --keep_datapoints --n_epochs ${n_epochs} --n_samples_dataset ${n} --n_samples_dataset_test ${n} --seed ${s}"
    done
  done
done