def print_loss_dict_tensors(epoch, loss_dict):
    no_tensors_dict = dict((k, v.item()) for (k, v) in loss_dict.items())
    print_loss_dict(epoch, no_tensors_dict)


def print_loss_dict(epoch, loss_dict):
    formatted_losses = ", ".join([f"{key}: {value:.3f}" for key, value in loss_dict.items()])
    print(f"Epoch {epoch}: {formatted_losses}")


def add_n_param_in_signature(signature: str, model_name: str, n_param: str) -> str:
    if not signature.startswith(model_name):
        raise ValueError("The string does not start with the specified model name.")

    return f"{model_name}_np{n_param}{signature[len(model_name):]}"
