def docx_to_md(local_path):
    """
    Converts a DOCX file to Markdown format.

    Args:
        local_path (str): The local path of the DOCX file.

    Returns:
        str: The converted Markdown content.
    """
    import mammoth
    from bs4 import BeautifulSoup
    import markdownify

    def _convert(html_content):
        """Helper function that converts and HTML string."""

        # Parse the string
        soup = BeautifulSoup(html_content, "html.parser")

        # Remove javascript and style blocks
        for script in soup(["script", "style"]):
            script.extract()

        # Print only the main content
        body_elm = soup.find("body")
        webpage_text = ""
        if body_elm:
            webpage_text = markdownify.MarkdownConverter().convert_soup(body_elm)
        else:
            webpage_text = markdownify.MarkdownConverter().convert_soup(soup)
        return webpage_text

    with open(local_path, "rb") as docx_file:
        result = mammoth.convert_to_html(docx_file)
        html_content = result.value
        result = _convert(html_content)
    return result