from experiments_hitting_time import *
import argparse


# x = utils.to_dataset({
#     "graph_type": ["football"],
#     "n": np.linspace(40000, 60000, 10),
#     "seed": range(5),
# })

# plot_hitting_time(x, "n", ["error", "time"], verbose=False)

# This one is a bit of a hard example. 
# Local-delete algorithm does really well with not that many samples!
# Cutoff does bad in this one!
def test_facebook_large():
    graph_types = ["facebook"]
    node_strategies = ["first-last"]

    x = utils.to_dataset({
        "graph_type": graph_types,
        "node_strategy": node_strategies,
        "algorithm": ["cutoff", "exact", "local-delete"],
        "seed": range(3)
    })

    plot_hitting_time(x, None, ["error", "time"], verbose=False, groups=["node_strategy", "algorithm"], graph_type=graph_types[0])

def test_facebook_small():    
    graph_types = ["facebook-small"]
    node_strategies = ["first-last"]

    x = utils.to_dataset({
        "graph_type": graph_types,
        "node_strategy": node_strategies,
        "algorithm": ["cutoff", "exact"],
        "seed": range(3)
    })

    plot_hitting_time(x, None, ["error", "time"], verbose=False, groups=["node_strategy", "algorithm"], graph_type=graph_types[0])


def test_communities():
    graph_types = ["communities"]
    n = np.linspace(1000, 3000, 10).astype(int)

    x = utils.to_dataset({
        "graph_type": graph_types,
        "n": n,
        "communities_inter_p": [0.1],
        "communities_intra_p": [0.8],
        "node_strategy": ["random"],
        "algorithm": ["cutoff", "exact", "local-delete", "sampling"],
        "seed": range(3),
    })

    plot_hitting_time(x, "n", ["error", "time"], verbose=False, groups=["algorithm"], graph_type=graph_types[0], n=n[0])


def test_barabasi_albert():
    graph_types = ["barabasi-albert"]
    n = [2000] # np.linspace(1000, 2000, 10).astype(int)

    x = utils.to_dataset({
        "graph_type": graph_types,
        "n": n,
        "m": np.linspace(10, 500, 10).astype(int),
        "node_strategy": ["random"],
        "algorithm": ["cutoff", "exact", "local-delete", "sampling"],
        "seed": range(5),
    })

    plot_hitting_time(x, "m", ["error", "time"], verbose=False, \
                      groups=["algorithm"], graph_type=graph_types[0], n=n[0])
    
def test_erdos_renyi():
    graph_types = ["erdos-renyi"]
    n = np.linspace(1000, 3000, 10).astype(int)

    x = utils.to_dataset({
        "graph_type": graph_types,
        "n": n,
        "erdos_renyi_p": [0.4],
        "node_strategy": ["random"],
        "algorithm": ["exact", "local-delete", "cutoff", "sampling"],
        "seed": range(4),
    })

    plot_hitting_time(x, "n", ["error", "time"], verbose=False, groups=["algorithm"], graph_type=graph_types[0], n=n[0])

if __name__ == "__main__":
    # Read arguments from command line:
    #   "er" for Erdos-Renyi
    #   "ba" for Barabasi-Albert
    #   "com" for Communities
    parser = argparse.ArgumentParser(description="Run hitting time experiments.")
    parser.add_argument("graph_type", type=str, choices=["er", "ba", "com", "fb-sm", "fb"],
                        help="Type of graph to use for the experiments.")
    
    args = parser.parse_args()
    graph_type = args.graph_type
    
    if graph_type == "er":
        test_erdos_renyi()
    elif graph_type == "ba":
        test_barabasi_albert()
    elif graph_type == "com":
        test_communities()
    elif graph_type == "fb-sm":
        test_facebook_small()
    elif graph_type == "fb":
        test_facebook_large()