import networkx as nx
import numpy as np



def get_graph(graph_type=None, n=None, barabasi_albert_m=None,
        erdos_renyi_p=None, communities_inter_p=None, communities_intra_p=None,
        seed=None, lazy=False, **kwargs):
    for _ in range(100):
        if graph_type == "erdos-renyi":
            G = nx.erdos_renyi_graph(n, erdos_renyi_p, seed=seed)

        elif graph_type == "barabasi-albert":
            G = nx.barabasi_albert_graph(int(n), int(barabasi_albert_m), seed=seed)

        elif graph_type == "karate-club":
            G = nx.karate_club_graph()

        elif graph_type == "lollipop":
            k = n // 2
            G = nx.lollipop_graph(k, k)

        elif graph_type == "communities":
            n2 = n // 2
            n3 = int(np.sqrt(n2))
            sizes = n3 * np.ones(n3, dtype=int)
            sizes[:n2 - n3**2] += 1
            sizes = [n - n2] + list(sizes)
            n4 = len(sizes)
            p = np.zeros((n4, n4))
            p[:, 0] = communities_inter_p
            p[0, :] = communities_inter_p
            p[range(n4), range(n4)] = communities_intra_p
            # import pdb; pdb.set_trace()
            G = nx.stochastic_block_model(sizes, p, seed=seed)
            G = nx.convert_node_labels_to_integers(G)

        elif graph_type == "grid":
            k = int(np.sqrt(n))
            G = nx.grid_2d_graph(k, k)
            G = nx.convert_node_labels_to_integers(G)

        elif graph_type == "football":
            G = nx.read_gml("datasets/football.gml")
            G = nx.convert_node_labels_to_integers(G)

        elif graph_type == "facebook":
            G = nx.read_edgelist("datasets/facebook_combined.txt")
            G = nx.convert_node_labels_to_integers(G)

        elif graph_type == "facebook-small":
            G = nx.read_edgelist("datasets/1912.edges")
            c = max([(len(c), c) for c in nx.connected_components(G)])[1]
            G = G.subgraph(c)
            G = nx.convert_node_labels_to_integers(G)

        elif graph_type == "twitter":
            G = nx.read_edgelist("datasets/twitter_combined.txt")
            G = nx.convert_node_labels_to_integers(G)

        elif graph_type == "amazon":
            G = nx.read_edgelist("datasets/com-amazon.ungraph.txt")
            G = nx.convert_node_labels_to_integers(G)

        else:
            assert(False)

        if lazy:
            G.add_edges_from([(u, u) for u in G.nodes])

        if nx.is_connected(G):
            assert(not nx.is_directed(G))
            return G

        seed += 1000

    print("Failed to create graph.")
    assert(False)


