#!/usr/bin/env python
# -*- coding: utf-8 -*-

import numpy as np


class ESModel(object):
    def __init__(self, pair_num, maze_shape):
        rank_weights = np.zeros(shape=pair_num)
        maze_weights = np.zeros(shape=(pair_num, *maze_shape))
        self.weights = [rank_weights, maze_weights]

    def get_rank_prob(self):
        out = self.weights[0]
        return out

    def get_maze_data(self):
        out = np.maximum(self.weights[1], 0) * 10.

        return out

    def get_weights(self):
        return self.weights

    def set_weights(self, weights):
        self.weights[0] = np.clip(weights[0], a_min=-10., a_max=10.)
        self.weights[1] = weights[1]
