# ASOS-dataset-sample

<h2>A sample dataset of 1001 ASOS products</h2>

![ASOS products dataset header](https://github.com/luminati-io/ASOS-dataset-sample/blob/main/ASOS-dataset.png)

A ASOS products dataset sample of over 1000 records. Dataset was extracted using the <b>Bright Data API</b>.

<h2>Some of the data points that are included in the ASOS products dataset:</h2>

* ```url```: Link to the product on Asos  
* ```name```: The name of the product  
* ```brand```: The brand associated with the product  
* ```description```: Textual details describing the product  
* ```about_me```: Additional information or details about the product  
* ```availability```: Indicates whether the product is currently available  
* ```buy_the_look```: Information about purchasing the entire look  
* ```category```: The category to which the product belongs  
* ```discount```: The discount applied to the product  
* ```image```: Links to images of the product  
* ```look_after_me```: Instructions or details about caring for the product  
* ```possible_sizes```: Available sizes for the product  
* ```price```: The cost of the product  
* ```product_details```: Additional details about the product  
* ```size_fit```: Information about the size and fit of the product  
* ```you_might_also_like```: Suggestions for other products the user might like  
* ```product_id```: Unique identifier for each product  
* ```breadcrumbs```: Hierarchical representation of the product  
* ```currency```: The currency in which the price is denominated  
* ```color```: The color or color options available for the product  

And a lot more.

This is a sample subset which is derived from the "ASOS products"
dataset which includes more than <b>2.6M records</b>.

Available dataset file formats: <b>JSON, NDJSON, JSON Lines, CSV, or Parquet. Optionally, files can be compressed to .gz</b>.

Dataset delivery type options: <b>Email, API download, Webhook, Amazon S3, Google Cloud storage, Google Cloud PubSub, Microsoft Azure, Snowflake, SFTP</b>.

Update frequency: <b>Once, Daily, Weekly, Monthly, Quarterly, or Custom basis</b>.

Data enrichment available as an addition to the data points extracted: <b>Based on request.</b>

<b>[Get the full ASOS products dataset](https://brightdata.com/products/datasets/asos)</b>.

<h2>What are the ASOS products datasets use cases?</h2>

<h3>1. Pricing Optimization</h3>
Develop dynamic pricing strategies by analyzing comparable fashion items and categories within the ASOS dataset to uncover competitive pricing opportunities.

<h3>2. Product Inventory</h3>
Identify inventory shortages and detect growing demand for specific fashion items, uncovering trends that appeal to consumers using the ASOS dataset.

<h3>3. Market Strategy</h3>
Leverage the ASOS dataset to analyze market trends and consumer preferences, driving more informed strategic decisions in the fashion industry.

<h2>Free access to web scraping tools and datasets for academic researchers and NGOs</h2>

The Bright Initiative offers access to Bright Data's <b>[Web Scraper APIs](https://brightdata.com/products/web-scraper)</b> and <b>[ready-to-use datasets](https://brightdata.com/products/datasets)</b> to leading academic faculties and researchers, NGOs and NPOs promoting various environmental and social causes. You can submit an application <b>[here](https://brightinitiative.com)</b>.
