from opto import trace
from opto.trace import node

@trace.model
class ReversingAgent:
    """Agent specialized for reversing challenges."""
    
    def __init__(self, task_name="reversing"):
        self.task_name = task_name
    
    @trace.bundle(trainable=True)
    def analyze(self, binary_path, challenge_description) -> str:
        """Analyze binary and extract the flag.
        
        CRITICAL: You MUST maintain the exact function signature.
        
        This is a reversing challenge involving binary analysis.
        
        Common reversing techniques:
        - Use `strings` command to find readable text
        - Check for UPX packing with `upx -d` to unpack
        - Look for flag patterns in binary data
        - Analyze file headers and metadata
        
        Available tools:
        - subprocess to run system commands
        - os for file operations  
        - re for pattern matching
        
        Args:
            binary_path: Path to the binary file to analyze
            challenge_description: Description of the challenge
            
        Returns:
            str: The discovered flag
        """
        # Start with empty implementation
        return "" 