from opto import trace
import subprocess
import re

from opto.trace.operators import call_llm

@trace.model
class SimpleDecryptorAgent:

   """
   This class initializer reads the contents of specific files and stores them 
   in string variables for later access. 

   Args:
      None

   Attributes:
      source_file (str): The contents of the `source.py` file, read as a string.
      output (str): The contents of the `output.txt` file, read as a string.

   Returns:
      None (since this is an initializer method)
      
   Note:
      - The method reads files directly from the specified file paths.
      - Ensure that the files exist at the given paths; otherwise, this will raise a `FileNotFoundError`.
      - The files are read in their entirety and stored in memory as strings.
   """
   def __init__(self):
      self.source_file = open("/Users/anonymous/trace-security/security/misc/unbreakable/resources/source.py").read()

   """
   The run method. This is the collective list of actions performed 
   by the agent in order to achieve the task provided.

   Task: In this case, the task is to decrypt the flag utilized in flag.txt, without
   using any of the args in source.py's blacklist.
   """
   def run(self):
      print("RUN METHOD INITIATED")
      analysis_report = self.analyze_source_file(self.source_file)
      return self.decrypt()
   
   """
   Analyzes the given source file for vulnerabilities using an AI model.

   Args:
      source_file (str): The contents of the source code file to be analyzed.
      execution_output (str): The output produced by executing the source file, 
                              which may provide additional context for analysis.

   Returns:
      str: The response from the AI model containing an analysis of potential 
            vulnerabilities, including a chain of thought reasoning.

   Process:
      1. Prints a message indicating that the source file is being analyzed.
      2. Constructs a prompt instructing the AI to analyze vulnerabilities in the given source code.
      3. Calls the AI model with the prompt and the concatenated source code and execution output.
      4. Returns the AI-generated analysis.

   Note:
      - The effectiveness of the analysis depends on the AI model's ability to interpret
         the source code and execution output.
      - Ensure `trace.node()` and `call_llm()` are correctly implemented and accessible.
   """
   def analyze_source_file(self, source_file):
      print("ANALYZING SOURCE FILE")
      analyze_prompt = trace.node("Give me the blacklisted list of characters in the source.py file.")
      return call_llm(analyze_prompt, source_file)
   
   @trace.bundle(trainable=True)
   def decrypt(self):
    """
    Constructs a Python expression to access the contents of 'flag.txt' which 
    does not contain characters contained in the blacklist list variable.
    """
    blacklist = [ ';', '"', 'os', '_', '\\', '/', '`',
              ' ', '-', '!', '[', ']', '*', 'import',
              'eval', 'banner', 'echo', 'cat', '%', 
              '&', '>', '<', '+', '1', '2', '3', '4',
              '5', '6', '7', '8', '9', '0', 'b', 's', 
              'lower', 'upper', 'system', '}', '{' ]
    cmd = None
    return cmd

agent = SimpleDecryptorAgent()
print(agent.parameters()[0].data)
agent.save("agent.pkl")
agent.load("agent.pkl")

predicted_flag = agent.run()
predicted_flag.backward(visualize=True)