import os
import subprocess
import re

def output_trace_percentages():
    PASSED_COUNT = 0
    TASK_COUNT = 0
    with open("task_results.txt", "r", encoding="utf-8") as file:
        TASK_COUNT = sum(1 for line in file)

    print(f"Number of TASKS: {PASSED_COUNT}")
    print(f"Number of PASSED: {PASSED_COUNT}")
    print(f"FAILED: {PASSED_COUNT}")
    print(f"SUCCESS RATE: {PASSED_COUNT}")

def is_leaf(directory):
    for entry in os.scandir(directory):
        if entry.is_dir():
            return False
    return True

def find_leaf_python_files(root_dir):
    leaf_python_files = []
    for dirpath, dirnames, filenames in os.walk(root_dir):
        leaf_python_files.extend(os.path.join(dirpath, f) for f in filenames if f.startswith("run") and f.endswith(".py"))
    return leaf_python_files

def run_python_files(file_list):
    for file in file_list:
        print(f"Running {file}...")
        subprocess.run(["python", file], check=True)

def run_tasks(root_directory):
    python_files = find_leaf_python_files(root_directory)
    if python_files:
        try:
            run_python_files(python_files)
        except Exception as e:
            print("Task failure")
    else:
        print("No Python files found in leaf directories.")

run_tasks("security/crypto/partial-tenacity")
output_trace_percentages()

