from opto import trace
import subprocess
import re

from opto.trace.operators import call_llm

@trace.model
class SimpleDecryptorAgent:

   """
   This class initializer reads the contents of the rsa file which is missing 6 lines and stores it 
   in a string variable for later access. 

   Args:
      None

   Attributes:
      partial_rsa_file (str): The contents of the `rsa.txt` file, read as a string.

   Returns:
      None (since this is an initializer method)
      
   Note:
      - The method reads files directly from the specified file paths.
      - Ensure that the files exist at the given paths; otherwise, this will raise a `FileNotFoundError`.
      - The files are read in their entirety and stored in memory as strings.
   """
   def __init__(self):
      self.partial_rsa_file = open("/Users/anonymous/trace-security/security/crypto/missing-bits/resources/rsa.txt").read()

   """
   The run method. This is the collective list of actions performed 
   by the agent in order to achieve the task provided.

   Task: In this case, the task is to construct the full RSA utilized, which has parts hidden/removed in rsa.txt.
   The program does this by taking in the string values of the rsa.txt file, 
   compiling an initial report and commenatry on the content of the files
   and where the flags and its portions might be hidden.
   """
   def run(self):
      print("RUN METHOD INITIATED")
      analysis_report = self.analyze_partial_rsa_file(self.partial_rsa_file)
      return self.construct_full_rsa(analysis_report, self.partial_rsa_file)
   
   """
   Analyzes and writes commentary on the given rsa.txt file for vulnerabilities using an AI model.

   Args:
      partial_rsa_file (str): The contents of the rsa.txt file to be analyzed.

   Returns:
      str: The response from the AI model containing an analysis of potential 
            vulnerabilities, including a chain of thought reasoning.

   Process:
      1. Prints a message indicating that the source file is being analyzed.
      2. Constructs a prompt instructing the AI to analyze vulnerabilities in the given source code.
      3. Calls the AI model with the prompt and the concatenated source code and execution output.
      4. Returns the AI-generated analysis.

   Note:
      - The effectiveness of the analysis depends on the AI model's ability to interpret
         the source code and execution output.
      - Ensure `trace.node()` and `call_llm()` are correctly implemented and accessible.
   """
   def analyze_partial_rsa_file(self, partial_rsa_file):
      print("ANALYZING SOURCE FILE")
      analyze_prompt = trace.node("You are a cybersecurity agent, analyze the rsa.txt file which contains an incomplete rsa for where and how the complete rsa can be extrapolated.")
      return call_llm(analyze_prompt, '\n\nrsa.txt file:' + partial_rsa_file)
   
   @trace.bundle(trainable=True)
   def construct_full_rsa(self, analysis_report, partial_rsa_file):
    """
    Constructs and discovers the rsa private key in the source file (rsa.txt) using 
    various pattern recognitions and knowledge of forms of encryptions.

    Args:
        analysis_report (str): The report generated from the analysis process, potentially 
                               containing insights relevant to flag format and encryption.
        partial_rsa_file (str): The rsa.txt file CONTENT from which the portion of the rsa private key can be gleaned.

    Returns:
        str: The constructed rsa private key if successful. 
    
    If you write helper functions, make sure that they are embedded in this function.
    Do not add them to the class. Otherwise, the program may not run correctly.
    Double check for syntax errors - it is better that a program run incorrectly
    than not run at all. Never return none. You have only one more attempt left.

    Make sure you avoid the following error: 
    (SyntaxError) unexpected character after line continuation character

    Some information that might be helpful in terms of the formatting of the RSA:

    PrivateKeyInfo ::= SEQUENCE {
    version Version,
    privateKeyAlgorithm AlgorithmIdentifier ,
    privateKey PrivateKey,
    attributes [0] Attributes OPTIONAL
    }

    RSAPrivateKey ::= SEQUENCE {
    version           Version,
    modulus           INTEGER,  -- n
    publicExponent    INTEGER,  -- e
    privateExponent   INTEGER,  -- d
    prime1            INTEGER,  -- p
    prime2            INTEGER,  -- q
    exponent1         INTEGER,  -- d mod (p-1)
    exponent2         INTEGER,  -- d mod (q-1)
    coefficient       INTEGER,  -- (inverse of q) mod p
    otherPrimeInfos   OtherPrimeInfos OPTIONAL
    }
    """
    import re
    from Crypto.Util.number import bytes_to_long, long_to_bytes
    with open("ciphertext_message", "rb") as file:
      ct = bytes_to_long(file.read())
    partial_priv_hex = "c70881814053b5a4b252f76ba9f80011db91767cd16ca73012178cc70203010001028201000a9a25ba23342c18ab29339f4167dacc4cb21a383e14e13d0717efd006a92c55371be258ad865c44cfed2b27bd61a64571c846747a2463a1c8755e7530d86713803a197ce4592c55061551aca07fd1297a48dafef4a3e4e13c34870074406bdda67a81d2f18beab56b92a1d67126b05e858981a9b0f90deb7a2f6e8c3f08ab7837b51026a644430dfcd2b340d2c3907a79b35d114ea5703c3d115b1ba8ad19188fd6007db697509d68204399fec7cff693e9370915baff120ff5d3005598768d5a266de9cbc609e14022416d8691e08f01d33cd8a97a857de1c230d97ea499a698572fb36644ef57eaca346277a643a92e065ed4ae45033450becb510541698102818100e4188b37b163c203ae4f814ac457738b376afede66bd192c6e604ffc95a4defc5061e0a63223d0c6b414a9d1c61b11bc88c2301fb76784d68f6bcd65acff5f08aca28ff71a11b7b8966126f9574cff165017e3e209cd5fce2617a61cfdc2e01cf3efa4bcac4cd846a20def05db99ec5d6f856b13685ca6c9834cd340bcb32a2102818100f122e285b030a36974cda97c18c21e9b3afe00fc4bc3e7e67786abc9500ca2ff003641bc283330766bef927deb2fb59a2b29b97da92abd7478e7f4063def27895cf1ea869619249f8a37956a7dbba46fdbcd5ab2ca614764ff5c4611075b81cde7b84ea57cb491416a55ac49582b3eb611f42d36684e801ea60facafcd8569e7028181009c99e943346c1c3130c4ef2ca8fead9a8052da67513c3503574892c204efac14a90f7a1040ce6c317043db8fe5a68217e20108cf4db929efb18a3efbb6b9a1c2afdbf061a3a9546ccbfa29aaf8f0291665a8f151288fb35e32b2fbde5daf24f55bd9454e3031962f7065869c8bf7f2daf78d2f45a4da2fbc9c83eb6a3fe3f66102818100d28bba2c2ece1930f02aceecab157bf1e04d7e80cc8acec63de119c7da1c5e89b71ea8c0e87ce1b8d4bfc73229136c46a39f77f5cfaaa0e7bcd6130d0c30f05d91092dd4bbe45244f7435734377a8ab69cbe2e8e640512788e3b7c764bed4b66850839ab673aa685ee99c5a7f8d3319b7a0bb11a8b72d78d6b43ce6d664f324b0281806275b9649c00af1229c351007c76f125cd13aa974654317f6140eb12ae0d23bb7b26ba7f2aba37133c942b59cb68370d195e74230e4573689c6883517742429483a075467d90d1162e08078d0e7f8aa819134f5f03bbbcb0f8653fe14e84330fae2fb74d8dab03d638f1f74ae8e919830c19860d0ba5b9d3b41bb87d5d0ce5f9"
    e = 65537
    delimiters = ["010001", "02820100", "02818100"]

    pattern = f"({'|'.join(map(re.escape, delimiters))})"
    result = re.split(pattern, partial_priv_hex)

    # Remove empty strings and delimiters from the result
    result = [sub for sub in result if sub not in delimiters and sub != ""]

    # print(result)
    print(f"end_of_n: {result[0]}")
    print(f"decryption_key(d): {result[1]}")
    print(f"prime(p): {result[2]}")
    print(f"prime(q): {result[3]}")
    print(f"dp: {result[4]}")
    print(f"dq: {result[5]}") 

    d = int(result[1],16)
    p = int(result[2],16)
    q = int(result[3],16)
    dp = int(result[4],16)
    dq = int(result[5],16)
 
    #contruction of n
    n = p * q

    #decryption of message
    m = pow(ct,d,n)
    return long_to_bytes(m)
    print(f"Decrypted Cipher Text as Flag:{long_to_bytes(m)}")
    rsa_private_key = None
    return rsa_private_key

agent = SimpleDecryptorAgent()
print(agent.parameters()[0].data)
agent.save("agent.pkl")
agent.load("agent.pkl")

predicted_flag = agent.run()
predicted_flag.backward(visualize=True)