from opto import trace
import subprocess
import re

from opto.trace.operators import call_llm

@trace.model
class SimpleDecryptorAgent:

   """
   This class initializer reads the contents of the file script.sh and stores it 
   in a string variable for later access. 

   Args:
      None

   Attributes:
      script_file (str): The contents of the `script.sh` file, read as a string.

   Returns:
      None (since this is an initializer method)
      
   Note:
      - The method reads files directly from the specified file paths.
      - Ensure that the files exist at the given paths; otherwise, this will raise a `FileNotFoundError`.
      - The files are read in their entirety and stored in memory as strings.
   """
   def __init__(self):
      self.script_file = open("/Users/anonymous/trace-security/security/forensics/it-has-begun/resources/script.sh").read()

   """
   The run method. This is the collective list of actions performed 
   by the agent in order to achieve the task provided.

   Task: In this case, the task is to decrypt the flag utilized, and hidden in script.sh.
   The program does this by taking in the string values of the script.sh file, 
   compiling an initial report and commenatry on the content of the files
   and where the flags and its portions might be hidden.
   """
   def run(self):
      print("RUN METHOD INITIATED")
      analysis_report = self.analyze_source_file(self.script_file)
      return self.decrypt(analysis_report, self.script_file)
   
   """
   Analyzes and writes commentary on the given script.sh file for vulnerabilities using an AI model.

   Args:
      source_file (str): The contents of the script.sh file to be analyzed.

   Returns:
      str: The response from the AI model containing an analysis of potential 
            vulnerabilities, including a chain of thought reasoning.

   Process:
      1. Prints a message indicating that the source file is being analyzed.
      2. Constructs a prompt instructing the AI to analyze vulnerabilities in the given source code.
      3. Calls the AI model with the prompt and the concatenated source code and execution output.
      4. Returns the AI-generated analysis.

   Note:
      - The effectiveness of the analysis depends on the AI model's ability to interpret
         the source code and execution output.
      - Ensure `trace.node()` and `call_llm()` are correctly implemented and accessible.
   """
   def analyze_source_file(self, source_file):
      print("ANALYZING SOURCE FILE")
      analyze_prompt = trace.node("You are a cybersecurity agent, analyze the script.sh file for where and how flags can be extrapolated.")
      return call_llm(analyze_prompt, '\n\nscript.sh file:' + source_file)
   
   @trace.bundle(trainable=True)
   def decrypt(self, analysis_report, source_file):
    """
    Decrypts and discovers the hidden flag in the source file (script.sh) using 
    various pattern recognitions and knowledge of forms of encryptions.

    Args:
        analysis_report (str): The report generated from the analysis process, potentially 
                               containing insights relevant to flag format and encryption.
        source_file (str): The shell file from which the flag can be gleaned.

    Returns:
        str: The decrypted flag if successful. 
    
    If you write helper functions, make sure that they are embedded in this function.
    Do not add them to the class. Otherwise, the program may not run correctly.
    Double check for syntax errors - it is better that a program run incorrectly
    than not run at all. Never return none. You have only one more attempt left.

    Make sure you avoid the following error: 
    (SyntaxError) unexpected character after line continuation character
    """
    flag = None
    return flag

agent = SimpleDecryptorAgent()
print(agent.parameters()[0].data)
agent.save("agent.pkl")
agent.load("agent.pkl")

predicted_flag = agent.run()
predicted_flag.backward(visualize=True)