from opto.trace import node, GRAPH

def print_node(node):
    print(node)
    print(f"parents: {[p.name for p in node.parents]}")

# Trace -> a computational graph framework for tracing & optimizing codes.
# Core Data Structure -> "node" container of python objects.
# To create a node, use a NODE method, which creates a Node Object.
# To access the CONTENT of a Node, use the DATA attribute.

x = node(1)  # node of int
print("node of int", x.data)
x = node("string")  # node of str
print(x.data)
x = node([1, 2, 3])  # node of list
print(x.data)
x = node({"a": 1, "b": 2})  # node of dict
print(x.data)


class Foo: # arbitrary class Foo
    def __init__(self, x):
        self.x = x
        self.secret = "secret"

    def print(self, val):
        print(val)


x = node(Foo("foo"))  # node of a class instance
print(x.data)