from opto import trace
from opto.optimizers import OptoPrime
from tutorials.battleship_agent import BattleshipBoard

GRAPH.clear()

board = BattleshipBoard(8, 8)

agent = BattleshipAgent()
obs = node(board.get_shots(), trainable=False)
optimizer = OptoPrime(agent.parameters())

feedback, terminal, cum_reward = "", False, 0

iterations = 0
while not terminal:
    try:
        output = agent.act(obs)
        obs, reward, terminal, feedback = user_fb_for_placing_shot(board, output.data)
    except trace.ExecutionError as e:
        output = e.exception_node
        feedback, terminal, reward = output.data, False, 0

    optimizer.zero_feedback()
    optimizer.backward(output, feedback)
    optimizer.step(verbose=False)