import os

from opto import trace
import autogen
from opto.optimizers import OptoPrime
from opto import trace
from opto import utils

@trace.model
class Agent:

    def __init__(self, system_prompt):
        self.system_prompt = system_prompt
        self.instruct1 = trace.node("Decide the language", trainable=True)
        self.instruct2 = trace.node("Extract name",  trainable=True)

    def __call__(self, user_query):
        # First LLM
        response = OptoPrime(self.system_prompt, self.instruct1, user_query)
        en_or_es = self.decide_lang(response)
        # Second LLM
        user_name = OptoPrime(self.system_prompt, self.instruct2, user_query)
        greeting = self.greet(en_or_es, user_name)
        return greeting

    @trace.bundle(trainable=True)
    def decide_lang(self, response):
        """Map the language into a variable"""
        return

    @trace.bundle(trainable=True)
    def greet(self, lang, user_name):
        """Produce a greeting based on the language"""
        greeting = "Hola"
        return f"{greeting}, {user_name}!"