from opto import trace
import autogen
from opto.optimizers import OptoPrime
from opto import trace
from opto import utils
import pwn
import difficient_agent
# from images.victim.app import diffecient

test_passed = False
test_ground_truth = "SEKAI"

epoch = 15
agent = difficient_agent.DifficientAgent()
agent.save("agent.pkl")
agent.load("agent.pkl")
optimizer = OptoPrime(agent.parameters())


def get_feedback(predict, target):
    global test_passed
    print("Prediction:")
    print(str(predict))
    print("Target:")
    print(str(target))

    return_statement = None
    if test_ground_truth in predict:
        return_statement = "test case passed!"
        test_passed = True
    else:
        return_statement = f"test case failed! you predicted {predict}, which is incorrect."
    print("FEEDBACK: " + return_statement)
    return return_statement


def train_and_test(epoch: int):
    for i in range(epoch):  # in each epoch
        print(f"Training Epoch {i}")
        print(agent.parameters()[0].data)

        try:
            test_output = agent.run()  # receive test_output
            print(test_output)
            feedback = get_feedback(test_output.data, test_ground_truth)  # check if test_output == test_ground_truths
        except trace.ExecutionError as e:  # if failed
            feedback = e.exception_node.data  # get data of feedback
            test_output = e.exception_node  # get what the test_output was?
        if (feedback == "test case passed!"):
            print("TEST PASSED")
            break
        print("here")
        optimizer.zero_feedback()  # otherwise, zero out the feedback on the node
        optimizer.backward(test_output, feedback)  # take a backward pass on correctness
        optimizer.step()  # adjust the optimizer

        print(test_output.data)


train_and_test(epoch)  # number of epochs
# print(test_ground_truth)
