from opto import trace

@trace.model
class BattleshipAgent:

  # this function is not changed by the optimizer
  def __call__(self, map):
      return self.select_coordinate(map).data

  # this function is not changed by the optimizer
  def select_coordinate(self, map):
      plan = self.reason(map)
      output = self.act(map, plan)
      return output

  @trace.bundle(trainable=True)
  def act(self, map, plan):
      """
      Given a map, select a target coordinate in a game.
      X denotes hits, O denotes misses,
      and . denotes unknown positions.
      """
      return

  @trace.bundle(trainable=True)
  def reason(self, map):
      """
      Given a map, analyze the board in a game.
      X denotes hits, O denotes misses,
      and . denotes unknown positions.
      """
      return