# README
We provide a minimal code base to help with the understanding of our method. The following section provides
a bash script that generates data and runs our method for many of our experiments.

The code here are part of a large code base
so we don't expect it to be runnable for now. However, we intend to clean up and release runnable code upon acceptance.
All code used to generate data and run our method are contained in this repo. 

This belongs to a private repo before official release so please use it only for paper review purpose.

# Collect data and train our method
```
# setup
ENV_ID=CHOSEN_ENV_ID
export MY_WANDB_ID=YOUR_WANDB_ID
ENV_EPS=0.5

# collect data
FILE="ckpts/$ENV_ID/policy_0.zip"
if [ -f "$FILE" ]; then
    echo "policy file $FILE exists, use soft link."
else
  echo "policy file for state not found, train new policies..."
  CUDA_VISIBLE_DEVICES=0,1 python experiments/train_expert.py --env_id "$ENV_ID" --total_steps 500000 --threads 10
fi

if [ ! -f "ckpts/${ENV_ID}" ]; then
  cd ckpts
  ln -s "${ENV_STATE_ID}" "${ENV_ID}"
  cd ..
fi

CUDA_VISIBLE_DEVICES=0,1 python experiments/collect_rollouts.py --env_id "$ENV_ID" --basis_type rand --steps 32000 --eps "$ENV_EPS" --threads 10
cd "buffer/$ENV_ID"
ln -s "rand_${ENV_EPS}_2048" rand_2048
ln -s "rand_${ENV_EPS}_2048" "rand_${ENV_EPS}_256"
cd ../..
CUDA_VISIBLE_DEVICES=0 python experiments/collect_rollouts.py --env_id "$ENV_ID" --basis_type learned --basis_dim 256 --steps 32000 --eps "$ENV_EPS"
cd "buffer/$ENV_ID"
ln -s "learned_${ENV_EPS}_256" learned_256
rm "rand_${ENV_EPS}_256"
cd ../..

# train
python experiments/benchmark.py --algo mpc --env_id "$ENV_ID" --seed 0
python experiments/benchmark.py --algo mbpo --env_id "$ENV_ID" --seed 0
python experiments/benchmark.py --algo cql --env_id "$ENV_ID" --seed 0
python experiments/benchmark.py --algo sf --basis_type learned --basis_dim 256 --env_id "$ENV_ID" --seed 0
```
