#!/usr/bin/env bash

# config="./configs/hmdb51/hmdb_zero_shot.yaml"
config="./configs/ucf101/ucf_zero_shot.yaml"
# config="./configs/k700/k700_zero_shot.yaml"

num_sim=1

top_k=10
num_beams=1
num_iter=10
temp="linear"
percentage=100
intra=True
inter=True
Q_style="max"
aug_p=0.2
name="ucf" # hmdb51 ucf kinetics_700
action="unified" # 'delete' 'substitute' 'insert' 'unified' 'space_insert', 'space_del'

# root="./exp/clip_k700/ViT-B/16/kinetics700/"
root="./exp/clip_ucf/ViT-B/16/ucf101/"
# root="./exp/clip_hmdb/ViT-B/16/hmdb51/"

now=$(date +"%Y%m%d_%H%M%S")

python aug.py --config ${config} --log_time ${now} --action ${action} --aug_p ${aug_p} --num_sim ${num_sim} --name ${name}

export CUDA_VISIBLE_DEVICES=1

for i in $(seq 1 ${num_sim})
do  
    python test_DENOISER.py --config ${config} --log_time ${now} --idx_sim ${i} --name ${name} --top_k ${top_k} --num_beams ${num_beams} --num_iter ${num_iter} --temp ${temp} --percentage ${percentage} --intra ${intra} --inter ${inter} --Q_style ${Q_style} 2>&1|tee ${root}/${now}/log_${i}_${top_k}_${num_beams}_${num_iter}_${temp}_${percentage}_${intra}_${inter}_${Q_style}_${now}_${aug_p}.txt
    sleep 1
done