#!/usr/bin/env bash

# config="./configs/hmdb51/hmdb_zero_shot.yaml"
config="./configs/ucf101/ucf_zero_shot.yaml"
# config="./configs/k700/k700_zero_shot.yaml"

num_sim=1

aug_p=0.2
name="ucf" # hmdb51 ucf kinetics_700
action="unified" # 'delete' 'substitute' 'insert' 'unified' 'space_insert', 'space_del'

# root="./exp/clip_k700/ViT-B/16/kinetics700/"
root="./exp/clip_ucf/ViT-B/16/ucf101/"
# root="./exp/clip_hmdb/ViT-B/16/hmdb51/"

now=$(date +"%Y%m%d_%H%M%S")

python aug.py --config ${config} --log_time ${now} --action ${action} --aug_p ${aug_p} --num_sim ${num_sim} --name ${name}

export CUDA_VISIBLE_DEVICES=1

for i in $(seq 1 ${num_sim})
do  
    python test_vanilla.py --config ${config} --log_time ${now} --idx_sim ${i} --name ${name} 2>&1|tee ${root}/${now}/log_${i}_${now}_${aug_p}.txt
    sleep 1
done