import numpy as np


tasks = {
    'junta7_unif': {
        'target_function': lambda X: X[:, :5].prod(axis=1) * ((1 + X[:, 3] + X[:, 4] - X[:, 3]*X[:, 4]) / 2),
        'mask': np.array([
        [1,1,1,1,1,1,1,0],  # x1·x2·x3·x4·x5
        [1,1,1,0,0,0,0,0],  # x1
        [1,1,1,1,0,0,0,0],  # x1·x2
        [1,1,1,1,1,0,0,0],  # x1·x2·x3
        [1,1,1,1,1,1,0,0],  # x1·x2·x3·x4
        [1,1,1,1,1,0,1,0],  # x1·x2·x3·x5
        [0,0,0,0,0,0,0,1]  # x6  (extra var)
    ]),
        'print_coefficients': True
    },
    'junta9_unif': {
        'target_function': lambda X: X[:, :7].prod(axis=1) * ((1 + X[:, 3] + X[:, 4] - X[:, 3]*X[:, 4]) / 2),
        'mask': np.array([
        [1,1,1,1,1,1,1,1,1,0],  # x1·x2·x3·x4·x5
        [1,1,1,1,1,0,0,0,0,0],  # x1
        [1,1,1,1,1,1,0,0,0,0],  # x1·x2
        [1,1,1,1,1,1,1,0,0,0],  # x1·x2·x3
        [1,1,1,1,1,1,1,1,0,0],  # x1·x2·x3·x4
        [1,1,1,1,1,1,1,0,1,0],  # x1·x2·x3·x5
        [0,0,0,0,0,0,0,0,0,1]  # x6  (extra var)
    ]),
        'print_coefficients': True
    },


    'parity5': {
        'target_function': lambda X: X[:, :5].prod(axis=1),
        'mask': np.array([
        [1,1,1,1,1,0],  # x1·x2·x3·x4·x5
        [1,0,0,0,0,0],  # x1
        [1,1,0,0,0,0],  # x1·x2
        [1,1,1,0,0,0],  # x1·x2·x3
        [1,1,1,1,0,0],  # x1·x2·x3·x4
        [0,0,0,0,0,1]  # x6  (extra var)
    ]),
        'print_coefficients': False
    },
    'parity25': {
        'target_function': lambda X: X[:,:25].prod(axis=1),
        'mask': np.array([[0]]),
        'print_coefficients': False
    },
}