##### Loading needed packages
library(signal)
library(astsa)
library(tidyr)



# set the parameters
J <- 10
Px <- 4
Py <- 3
T <- 1024

nrep <- 500
a_lsp <- array(0,c(nrep,Px,T))
b_lsp <- array(0,c(nrep,Py,T))
rho_lsp <- array(0,c(nrep,T))

a_lsw <- array(0,c(nrep,J,Px,T))
b_lsw <- array(0,c(nrep,J,Py,T))
rho_lsw <- array(0,c(nrep,J,T))

# generate nrep independent replicates
AR_data_list <- generate_replicates_AR(nrep = 500)
               
### calculate canonical coherence with WaveCanCoh and LSP based methods, with generated mixture AR2 data.
for (i in 1: nrep){
  X <- AR_data_list[[i]]$X
  Y <- AR_data_list[[i]]$Y
  filter_X <- filter_out(X, fsband=c(25,50),samprate =100, method = "butter",twosided = TRUE)
  filter_Y <- filter_out(Y, fsband=c(25,50),samprate =100, method = "butter",twosided = TRUE)
  test_lsp_spectrum_z <- lsp_spectrum_z(filter_X, filter_Y, window_size = 70)
  z_spectrum <- extract_spectrum_lsp(test_lsp_spectrum_z,c(4,3))
  Wavecan_lsp <- WaveCan_lsp(z_spectrum$Sxx,z_spectrum$Sxy,z_spectrum$Syx,z_spectrum$Syy)
  a_lsp[i,,] <- Wavecan_lsp$a
  b_lsp[i,,] <- Wavecan_lsp$b
  rho_lsp[i,] <- Wavecan_lsp$rho
  Wavecan_lsw <- Calculate_WaveCan(X,Y, filter_number = 4, wavelet_family = "DaubExPhase")
  a_lsw[i,,,] <- Wavecan_lsw$a
  b_lsw[i,,,] <- Wavecan_lsw$b
  rho_lsw[i,,] <- Wavecan_lsw$rho
}

rho_lsp_new <- rho_lsp


mean_a_lsp <- apply(a_lsp,c(2,3),mean)
mean_b_lsp <- apply(b_lsp,c(2,3),mean)

mean_a_lsw <- apply(a_lsw,c(2,3,4),mean)
mean_b_lsw <- apply(b_lsw,c(2,3,4),mean)

# Calculate means across replicates
mean_rho_lsp <- apply(rho_lsp, 2, mean)
mean_rho_lsw_scale1 <- apply(rho_lsw[,1,], 2, mean)



# Calculate mean and standard error across replicates
# 1) Smooth each replicate's curve first
rho_lsp_sm  <- t(apply(rho_lsp, 1, movmean, 50))
rho_lsw1_sm <- t(apply(rho_lsw[,1,], 1, movmean, 50))

T_len <- ncol(rho_lsw1_sm)

# Calculate mean and standard error for each time point
# For LSP
mean_lsp <- colMeans(rho_lsp_sm)
se_lsp <- apply(rho_lsp_sm, 2, function(x) sd(x)/sqrt(length(x)))
ci_lsp_low <- mean_lsp - 1.96 * se_lsp
ci_lsp_high <- mean_lsp + 1.96 * se_lsp

# For WaveCanCoh
mean_lsw <- colMeans(rho_lsw1_sm)
se_lsw <- apply(rho_lsw1_sm, 2, function(x) sd(x)/sqrt(length(x)))
ci_lsw_low <- mean_lsw - 1.96 * se_lsw
ci_lsw_high <- mean_lsw + 1.96 * se_lsw

plot_data_wald <- data.frame(
  Time        = rep(seq(0,1,length.out=T), 2),
  Method      = rep(c("LSP","WaveCanCoh"), each=T),
  Mean        = c(mean_lsp, mean_lsw),
  Lower_CI    = c(ci_lsp_low, ci_lsw_low),
  Upper_CI    = c(ci_lsp_high, ci_lsw_high)
)

ggplot(plot_data_wald, aes(x=Time, y=Mean, color=Method, fill=Method)) +
  geom_line(size=1) +
  geom_ribbon(aes(ymin=Lower_CI, ymax=Upper_CI), alpha=0.4, color=NA) +
  scale_color_manual(values=c(LSP="#2E86C1",WaveCanCoh="#E74C3C")) +
  scale_fill_manual(values=c(LSP="#2E86C1",WaveCanCoh="#E74C3C")) +
  labs(title=expression("Estimated"~hat(rho)~" with Wald's 95% CI"),
       x="Time", y=expression(hat(rho))) +
  theme_minimal() +
  theme(
    plot.title = element_text(size = 22, hjust = 0),
    axis.title = element_text(size = 16),
    axis.text = element_text(size = 14),
    legend.title = element_text(size = 14),
    legend.text = element_text(size = 12),
    legend.position = "right",
    panel.grid.major = element_line(color = "gray90", linewidth = 0.5),
    panel.grid.minor = element_line(color = "gray95", linewidth = 0.3),
    plot.margin = margin(t = 20, r = 20, b = 20, l = 20)
  )





