# WaveCanCoh: Wavelet-Based Canonical Coherence Analysis

This repository contains the implementation and analysis codes for the WaveCanCoh framework, as presented in our paper. The codes include simulation studies and real data analysis using R.

## Overview

This repository contains R codes for:
- Simulation studies with mvLSW model
- Simulation studies with mixture of AR2 processes
- LFP (Local Field Potential) data analysis
- Implementation of the Causal-WaveCanCoh framework

## Requirements

- R (version 4.0.0 or higher recommended)
- Required R packages (to be installed):
  ```R
  install.packages(c("wavelets", "wavethresh", "mvLSW", "ggplot2", "dplyr"))
  ```

## Repository Structure

```
.
├── functions.R           # Common utility functions
├── LSW/                 # mvLSW model simulation
│   └── LSW_sim.R       # Main simulation implementation
├── AR2/                 # AR2 process simulation
│   ├── AR2_sim_function.R  # AR2-specific functions
│   └── mixAR_sim.R     # Main AR2 simulation implementation
└── LFP/                 # LFP data analysis
    ├── LFP_analysis.R  # Main LFP analysis
    ├── LFP_analysis_timepoints_test.R  # Permutation test implementation
    └── causal_wavecancoh.R  # Causal-WaveCanCoh framework
```

## Usage Instructions

### 1. Setup

First, load the common functions:
```R
source("functions.R")
```

### 2. Simulation Studies

#### mvLSW Model Simulation
- Navigate to the `LSW` folder
- Run `LSW_sim.R` to reproduce the first simulation study
- This includes parameter setup, data generation, and visualization

#### AR2 Process Simulation
- Navigate to the `AR2` folder
- Run `mixAR_sim.R` to reproduce the second simulation study
- Note: The simulation may take considerable time
- For faster results, you can reduce the number of replicates (may increase bias)

### 3. LFP Data Analysis

The LFP data used in the paper is not publicly available. However, the provided code can be adapted for similar datasets:

- `LFP_analysis.R`: Main analysis including WaveCanCoh estimation and visualizations
- `LFP_analysis_timepoints_test.R`: Implementation of permutation tests for comparing correct/incorrect trials
- `causal_wavecancoh.R`: Implementation of the Causal-WaveCanCoh framework (see Appendix E in the paper)

## Reproducing Results

All simulation study results can be reproduced by running the provided codes in the following order:
1. Load `functions.R`
2. Run the mvLSW simulation (`LSW_sim.R`)
3. Load `AR2_sim_functions.R`
4.. Run the AR2 simulation (`mixAR_sim.R`)



