# P1 is numnber of channels of Y
# P2 is number of channels of X
# T is the length of time series
# J is the total number of scales/levels
# Spec is multi-variate time evolving spectrum matrix (mvEWS)

Px <- 6
Py <- 4
P <- Px + Py
T <- 1024
J <- log2(T)

# Specify the true spectrum first
Spec <- array(0, dim = c(P, P, J, T))
j <- 2
# Auto-Spectrum of X - ensure diagonal elements are positive and well-conditioned
Spec[1,1,j, ] <- 8 #c(rep(2,512),rep(4,512))  
Spec[2,2,j, ] <- 8#c(rep(2,512),rep(4,512))
Spec[3,3,j, ] <- 8#c(rep(2,512),rep(4,512))
Spec[4,4,j, ] <- 8#c(rep(2,512),rep(4,512))
Spec[5,5,j, ] <- 8#c(rep(2,512),rep(4,512))
Spec[6,6,j, ] <- 8#c(rep(2,512),rep(4,512))

# cross-spectrum within X - ensure symmetry and positive definiteness
Spec[1, 2, j, ] <- Spec[2, 1, j, ] <- 1
Spec[1, 3, j, ] <- Spec[3, 1, j, ] <- 1
Spec[4, 5, j, ] <- Spec[5, 4, j, ] <- 1
Spec[2, 6, j, ] <- Spec[6, 2, j, ] <- 1

# Auto-Spectrum of Y - ensure diagonal elements are positive and well-conditioned
Spec[7,7,j, ] <- 6
Spec[8,8,j, ] <- 6
Spec[9,9,j, ] <- 6
Spec[10,10,j, ] <- 6

# cross-spectrum within Y - ensure symmetry and positive definiteness
Spec[7, 9, j, ] <- Spec[9, 7, j, ] <- 1
Spec[8, 10, j, ] <- Spec[10, 8, j, ] <- 1
Spec[8, 9, j, ] <- Spec[9, 8, j, ] <- 1

# cross-spectrum between X and Y - ensure symmetry and positive definiteness
Spec[1, 7, j, ] <- Spec[7, 1, j, ] <- c(rep(1,512),rep(2,512))
Spec[2, 8, j, ] <- Spec[8, 2, j, ] <- c(rep(1,512),rep(2,512))
Spec[1, 10, j, ] <- Spec[10, 1, j, ] <- c(rep(1,512),rep(2,512))
Spec[3, 10, j, ] <- Spec[10, 3, j, ] <- c(rep(1,512),rep(2,512))
Spec[4, 7, j, ] <- Spec[7, 4, j, ] <- c(rep(1,512),rep(2,512))




# Ensure positive definiteness by adding small values to diagonal
#for(i in 1:P) {
#  Spec[i,i,2,] <- Spec[i,i,2,] + 1e-10
#}
for (j in 1:J){
  for (t in 1:T){
    Spec[,,j,t] <- Spec[,,j,t] + diag(1e-6,P)
    }
}

# Specify the true multivariate evolving wavelet spectrum
name <- c("X1","X2", "X3", "X4", "X5", "X6", "Y1", "Y2", "Y3", "Y4")
True_mvEWS <- as.mvLSW(x = Spec, filter.number = 1, family = "DaubExPhase",names = name, bias.correct = TRUE)


# The plot of specified spectrum, Figure 8 in the paper.
plot(True_mvEWS, style = 2, info = 2, ylim = c(0, 10), lwd = 2)



X <- rmvLSW(Spectrum = True_mvEWS)
# Bigger font size
# Font sizes
axis_size <- 1.4
label_size <- 1.7
time_rescaled <- seq(0,10,length.out = T)
# Adjusted margins: mar = c(bottom, left, top, right)
# More space on the left (increase 4), top is fine
par(mfrow = c(6, 1), mar = c(2, 5, 1, 1), oma = c(3, 0, 2, 0))
# Plot the first 6 X channels
for (i in 1:6) {
  plot(time_rescaled, X[, i], type = "l",
       xlab = "", ylab = bquote(X[.(i)]),
       main = "", xaxt = ifelse(i < 6, "n", "s"),
       cex.axis = axis_size, cex.lab = label_size)
}

mtext("Time", side = 1, line = 2, outer = TRUE, cex = label_size)

par(mfrow = c(4, 1), mar = c(2, 5, 1, 1), oma = c(3, 0, 2, 0))

for (i in 7:10) {
  plot(time_rescaled, X[, i], type = "l",
       xlab = "", ylab = bquote(Y[.(i - 6)]),
       main = "", xaxt = ifelse(i < 10, "n", "s"),
       cex.axis = axis_size, cex.lab = label_size)
}
mtext("Time", side = 1, line = 2, outer = TRUE, cex = label_size)


# calculate the true results of WaveCanCoh
lsw_spectrum_true <- extract_spectrum(True_mvEWS$spectrum,c(Px,Py))
lsw_results_true <- WaveCan(lsw_spectrum_true$Sxx,lsw_spectrum_true$Sxy,lsw_spectrum_true$Syx,lsw_spectrum_true$Syy)



# calculte the estimated WaveCanCoh with proposed framework
num_rep <- 1000 # number of replicates, can be replated with a small number to get results much quickly
group_size <- 10
seed <- 1126 # seed for reproducibility
lsw_results_sim <- do_multiple_LSW_simulation(Spec, group_size = group_size , num_rep = num_rep, Px = 6, Py = 4, seed = seed)


# calculate the CI based on the simulation results, method = normal or percentile
lsw_bootstrap_ci_normal <- calculate_bootstrap_CI(lsw_results_sim, method = "normal")


j <- 2
window_size <- 32 # add a smooth window to the plot
# For rho:
plot.wavecan(lsw_bootstrap_ci_normal, target = "rho", j = j, window_size = window_size, with_true = TRUE, true_results =lsw_results_true)
# For a:
plot.wavecan(lsw_bootstrap_ci_normal, target = "a", j = j, window_size = window_size, with_true = FALSE, true_results = NULL)
# For b:
plot.wavecan(lsw_bootstrap_ci_normal, target = "b", j = j, window_size =window_size, with_true = FALSE, true_results = NULL)



### for plot dropping the boundary effect of wavelet
lsw_results_true_drop <- lsw_results_true
lsw_bootstrap_ci_normal_drop <- lsw_bootstrap_ci_normal
boundary <- window_size
idx <- (boundary + 1):(dim(lsw_bootstrap_ci_normal_drop$rho$mean)[2] - boundary)

lsw_bootstrap_ci_normal_drop$rho$mean <- lsw_bootstrap_ci_normal_drop$rho$mean[, idx, drop = FALSE]
lsw_bootstrap_ci_normal_drop$rho$ci <- lsw_bootstrap_ci_normal_drop$rho$ci[, , idx, drop = FALSE]
lsw_results_true_drop$rho <- lsw_results_true_drop$rho[, idx, drop = FALSE]
plot.wavecan(lsw_bootstrap_ci_normal_drop, target = "rho", j = j, window_size = window_size, with_true = TRUE, true_results = lsw_results_true_drop)
