from abc import ABCMeta, abstractmethod


class BaseScore(object):
    """
    Abstract base class for all score functions.

    """
    __metaclass__ = ABCMeta

    def __init__(self) -> None:
        pass

    @abstractmethod
    def __call__(self, inputs, labels=None):
        """
        Virtual method to compute scores.
        If labels is not None, the function calculate the non-conformity score for  samples {(x_i,y_i)}.
        If labels is None, the function calculate the scores of all labels for the test instances {x_i}.

        :param inputs: the inputs of {x_i}.
        :param labels : the labels of {x_i}.
        """
        raise NotImplementedError
