import os
import csv


def add_dict_to_csv(file_path, data_dict):
    fieldnames = data_dict.keys()
    dir_path, file_name = os.path.split(file_path)

    if not os.path.exists(dir_path):
        os.makedirs(dir_path)

    try:    
        with open(file_path, 'r') as file:
            reader = csv.DictReader(file)
    except FileNotFoundError:
        with open(file_path, 'w', newline='') as file:
            writer = csv.DictWriter(file, fieldnames=fieldnames)
            writer.writeheader()

    with open(file_path, 'a', newline='') as file:
        writer = csv.DictWriter(file, fieldnames=fieldnames)
        writer.writerow(data_dict)
