#!/bin/bash

score_functions=("THR" "APS" "RAPS" "SAPS")
truncation_names=("base" "truncated")

for score in "${score_functions[@]}"
do
    for truncation_name in "${truncation_names[@]}"
    do 
        python run_main.py \
        --dataset imagenet\
        --trials 10\
        --predictor Split\
        --score ${score}\
        --truncation_name ${truncation_name}\
        --alpha 0.1\
        --gpu 1 \
        --conf_cal None\
        --tuning_criterion size\
        --n_cal 20000\
        --hyperpar 0
    done
done

