# Learn-Noise (Minimal)

A minimal, codebase for flow matching with optional learned quantiles across 2‑D toy targets and images (MNIST, CIFAR‑10).


## 2D Experiments

Train on 2‑D distributions via the dedicated CLI:

```
python -m learn_noise.cli_2d --config default      # generic 2‑D config
python -m learn_noise.cli_2d --config funnel       # Neal funnel config
```

Useful flags (shared across CLIs):
- `--baseline` to run the latent‑only flow‑matching baseline.
- `--pretrain` to pretrain the quantile transport before joint training.
- `--override key=value` to override top‑level config entries (e.g. `--override epochs=100000`).
- `--no-wandb` disables Weights & Biases logging (default in configs).



## Image Experiments (MNIST / CIFAR‑10)

Train on images via the images CLI:

```
python -m learn_noise.cli_images --config mnist
python -m learn_noise.cli_images --config cifar10
```

Notes:
- CIFAR‑10 and MNIST are normalized to `[-1, 1]`. CIFAR‑10 uses random horizontal flips.

## FID Evaluation (CIFAR‑10)

Compute FID against the CIFAR‑10 train set for a saved run:

```
python -m learn_noise.eval.run_fid RUN_DIR \
  --samples 50000 --batch 512 --device cuda --num-steps 100 10
```

Options:
- `--step` to choose a specific checkpoint step (falls back to the closest available).
- `--wandb` to enable W&B logging (disabled by default).
- `--data-root` to specify CIFAR‑10 dataset location.

## Configs

Configuration YAMLs live under:
- `learn_noise/configs/2d/` (e.g. `funnel.yaml`)
- `learn_noise/configs/images/` (e.g. `mnist.yaml`, `cifar10.yaml`)

Override any entry from the command line via `--override key=value`.


## Notes

- W&B is optional and off by default in configs; enable via CLI flags when desired.
- Checkpoints and samples are written under `results_2d/` or `results_img/` by default; adjust with `--output-root`.
