# 3D Gaussian Flats code

## Setting up the environment

The code is tested in a conda environment with CUDA 12.1.

```
conda env create --file environment.yml
```

## Obtaining data

1. Download ScanNet++ (https://kaldir.vc.in.tum.de/scannetpp/) and ScanNetV2 (http://www.scan-net.org) scenes

2. Undistort images using the provided toolkits (as 3DGS-based methods work only with undistorted images)

3. Render depth from meshes for evaluation

## Preprocessing mask

Refer to `data_preparation/README.md`

## Training

Sample training command for iPhone data, one needs to provide `cap_max` as the method is based on 3DGS-MCMC and `mask_root` for planar surfaces detection

```
python train_planar.py \
    -s scannetpp/data/0a7cc12c0e/iphone \ 
    -m output/0a7cc12c0e  \
    --init_type sfm \
    --resolution 2 \
    --cap_max 1593000 \
    --mask_root data_preparation/sam2/results_iphone/0a7cc12c0e
```

## Rendering

To render images run
```
python render.py \
    -s scannetpp/data/0a7cc12c0e/iphone \ 
    -m output/0a7cc12c0e
```

To render checkerboard texture for the planes run 
```
python render_checkerboard.py \
    -s scannetpp/data/0a7cc12c0e/iphone \ 
    -m output/0a7cc12c0e
```


## Extracting mesh
```
python mesh_from_masks.py \
    -s scannetpp/data/0a7cc12c0e/iphone \ 
    -m output/0a7cc12c0e
```

## Metrics


### Novel view synthesis and depth
```
python metrics.py \
    -m output/0a7cc12c0e \
    --scannetpp_depth_root scannetpp/data/0a7cc12c0e/iphone/depth
```


### Meshing

Follow the AirPlanes (https://github.com/nianticlabs/airplanes) evaluation procedure with extracted meshes

To generate ScanNet++ Ground Truth use `data_preparation/ground_truth/generate_ground_truth_scannetpp.py` similar to AirPlanes 
