# NatADiff

Experiment code for NatADiff: Adversarial Boundary Guidance for Natural Adversarial Diffusion.

## Installation
Installation requires the `gcontrol` package in addition to  the packages specified in the `environment.yml` file.

```
conda env create -f environment.yml
cd ../gcontrol
pip install . --no-deps
```

Then download the [ImageNet-Val](https://www.kaggle.com/c/imagenet-object-localization-challenge/overview) and [ImageNet-A](https://github.com/hendrycks/natural-adv-examples) datasets, and specify the appropriate paths to the datasets and desired experiment directories in `NatADiff/misc/path_configs.py`

## Quickstart

To jump in and start using NatADiff we recommend using the interactive notebook `NatADiff.ipynb`

## Running Experiments

To run the experiments from the main paper call:

```
python experiment_runner.py -rcnfg experiment_configs/***
```

where `***` is the config of the desired experiment. 

## Computing Stats

To run the <b>IS</b> and <b>FID</b> evaluations call:

```
python stats_runner.py -rcnfg experiment_configs/*** -sub_samp 1000 -sub_samp_type step
```

where `***` is the config of the desired experiment. 

To run the no-reference evaluations (<b>NIQE</b>, <b>BRISQUE</b>, <b>TReS</b>) first set up an environment to use `pyiqa`:

```
conda env create -f pyiqa.yml
```

Then add the experiment name to `noref_runner.py` and run
```
conda activate pyiqa
python noref_runner.py
```

## Authors

REDACTED