### Preamble ##########################################################################################################

"""
Paths for experiment caching and datasets, and imagenet class mappings.
"""

#######################################################################################################################

### Imports ###########################################################################################################

import os
import pathlib
import json
import pickle

#######################################################################################################################

### SPECIFY YOUR PATHS ################################################################################################

# Directory to cache the HuggingFace diffusion model(s)
CACHE_DIR = pathlib.Path("SPECIFY HUGGING FACE CACHE PATH")

# Directory to store experiment runs (each experiment run will create a new folder within this directory)
EXPERIMENT_DIR = pathlib.Path("SPECIFY DIRECTORY TO STORE NatADiff RUNS")

# Path to ImageNet dataset (download from https://www.kaggle.com/c/imagenet-object-localization-challenge/overview)
IMAGENET_PATH = pathlib.Path("SPECIFY PATH TO THE IMAGENET LARGE DATASET")

# Path to ImageNet-A dataset (download from https://github.com/hendrycks/natural-adv-examples)
IMAGENET_A_PATH = pathlib.Path("SPECIFY PATH TO THE IMAGENET-A DATASET")

#######################################################################################################################

if not CACHE_DIR.exists():
    raise FileNotFoundError(
        f"HuggingFace caching directory not found at, {CACHE_DIR}, did you forget to update",
        " `misc/path_configs.py`?",
    )
if not EXPERIMENT_DIR.exists():
    raise FileNotFoundError(
        f"Experiment caching directory not found at, {EXPERIMENT_DIR}, did you forget to update ",
        "`misc/path_configs.py`?",
    )
if not IMAGENET_PATH.exists():
    raise FileNotFoundError(
        f"ImageNet directory not found at, {IMAGENET_PATH}, did you forget to update ", "`misc/path_configs.py`?"
    )
if not IMAGENET_A_PATH.exists():
    raise FileNotFoundError(
        f"ImageNet-A directory not found at, {IMAGENET_A_PATH}, did you forget to update ", "`misc/path_configs.py`?"
    )

FILE_PATH = pathlib.Path(__file__).parent
with open(FILE_PATH / "imagenet_classes.json", "r") as fstrm:
    IMAGENET_CLASSES = json.load(fstrm)
IMAGENET_CLASSES["id2label"] = {int(k): v for k, v in IMAGENET_CLASSES["id2label"].items()}
IMAGENET_CLASSES["id2synset"] = {int(k): v for k, v in IMAGENET_CLASSES["id2synset"].items()}

#######################################################################################################################
