### Imports ###########################################################################################################

import pytest
import os

#######################################################################################################################

PRETRAINED_MODEL_PATH = ""
DATASET_PATH = ""

#######################################################################################################################

# Check if model paths are set
if not os.path.exists(PRETRAINED_MODEL_PATH):
    raise FileNotFoundError(
        "Please provide a valid `PRETRAINED_MODEL_PATH` to store models from HuggingFace for unit testing purposes"
    )
if not os.path.exists(DATASET_PATH):
    raise FileNotFoundError(
        "Please provide a valid `DATASET_PATH` to store models from HuggingFace for unit testing purposes"
    )

#######################################################################################################################


def pytest_addoption(parser):
    parser.addoption("--runslow", action="store_true", default=False, help="run slow tests")


def pytest_configure(config):
    config.addinivalue_line("markers", "slow: mark test as slow to run")


def pytest_collection_modifyitems(config, items):
    if config.getoption("--runslow"):
        # --runslow given in cli: do not skip slow tests
        return
    skip_slow = pytest.mark.skip(reason="need --runslow option to run")
    for item in items:
        if "slow" in item.keywords:
            item.add_marker(skip_slow)


#######################################################################################################################
