### Imports ###########################################################################################################

import pytest
import torch
import numpy as np

### Fixtunres ##########################################################################################################


@pytest.fixture
def mat_22():
    data = torch.tensor([[3.1105, -8.5693], [-3.2856, 3.8178]], dtype=torch.float32)
    return data


@pytest.fixture
def mat_122():
    data = torch.tensor([[[1.1105, -8.5693], [-3.2856, 4.8178]]], dtype=torch.float32)
    return data


@pytest.fixture
def mat_234():
    data = torch.tensor(
        [
            [[6.305, -7.1514, 5.4961, 4.3472], [7.1371, 8.135, 5.5692, 5.6468], [-5.8681, 6.3181, 2.328, 6.0371]],
            [[6.5097, 6.261, 0.7954, 9.1538], [1.0174, -9.3985, 1.0424, -5.6046], [0.7062, -2.1807, 4.803, 4.0484]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def mat_23112():
    data = torch.tensor(
        [
            [[[[2.3468, 4.2173]]], [[[2.2534, 0.4782]]], [[[4.9438, 7.1544]]]],
            [[[[9.6162, 4.6368]]], [[[4.1856, 1.1775]]], [[[7.5389, 2.2746]]]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def mat_231():
    data = torch.tensor([[[3.9335], [-5.585], [1.9859]], [[-0.3769], [4.9202], [-9.0358]]], dtype=torch.float32)
    return data


@pytest.fixture
def mean_0():
    data = torch.tensor(-6.0637, dtype=torch.float32)
    return data


@pytest.fixture
def std_0():
    data = torch.tensor(4.7886, dtype=torch.float32)
    return data


@pytest.fixture
def mean_1():
    data = torch.tensor([-6.0637], dtype=torch.float32)
    return data


@pytest.fixture
def std_1():
    data = torch.tensor([4.7886], dtype=torch.float32)
    return data


@pytest.fixture
def mean_2():
    data = torch.tensor([4.2988, 6.0153], dtype=torch.float32)
    return data


@pytest.fixture
def std_2():
    data = torch.tensor([-0.9023, 7.9698], dtype=torch.float32)
    return data


@pytest.fixture
def mean_231():
    data = torch.tensor([[[7.7497], [9.84], [-3.1244]], [[5.53], [0.5774], [7.844]]], dtype=torch.float32)
    return data


@pytest.fixture
def std_231():
    data = torch.tensor([[[-2.1871], [1.7717], [-7.1769]], [[7.3947], [-1.3193], [-6.4847]]], dtype=torch.float32)
    return data


@pytest.fixture
def nres_22_0():
    data = torch.tensor([[1.9158, -0.5232], [0.5801, 2.0635]], dtype=torch.float32)
    return data


@pytest.fixture
def nres_122_0():
    data = torch.tensor([[[1.4982, -0.5232], [0.5801, 2.2724]]], dtype=torch.float32)
    return data


@pytest.fixture
def nres_234_0():
    data = torch.tensor(
        [
            [[2.5829, -0.2271, 2.414, 2.1741], [2.7567, 2.9651, 2.4293, 2.4455], [0.0408, 2.5857, 1.7524, 2.527]],
            [[2.6257, 2.5738, 1.4324, 3.1779], [1.4787, -0.6964, 1.484, 0.0959], [1.4138, 0.8109, 2.2693, 2.1117]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def nres_23112_0():
    data = torch.tensor(
        [
            [[[[1.7564, 2.147]]], [[[1.7369, 1.3661]]], [[[2.2987, 2.7603]]]],
            [[[[3.2744, 2.2346]]], [[[2.1404, 1.5122]]], [[[2.8406, 1.7413]]]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def nres_234_2():
    data = torch.tensor(
        [
            [
                [-2.2234, 12.69, -1.3269, -0.0536],
                [-3.1456, -4.2516, -1.408, -1.494],
                [11.2678, -2.2379, 2.1842, -1.9265],
            ],
            [[0.062, 0.0308, -0.655, 0.3938], [-0.6271, -1.934, -0.624, -1.458], [-0.6662, -1.0284, -0.1521, -0.2468]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def nres_23112_231():
    data = torch.tensor(
        [
            [[[[2.4703, 1.6151]]], [[[-4.2821, -5.2841]]], [[[-1.1242, -1.4322]]]],
            [[[[0.5526, -0.1208]]], [[[-2.7349, -0.4549]]], [[[0.047, 0.8589]]]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def sres_22_0():
    data = torch.tensor([[14.8949, -41.0349], [-15.7334, 18.2819]], dtype=torch.float32)
    return data


@pytest.fixture
def sres_122_0():
    data = torch.tensor([[[5.3177, -41.0349], [-15.7334, 23.0705]]], dtype=torch.float32)
    return data


@pytest.fixture
def sres_234_0():
    data = torch.tensor(
        [
            [
                [30.1921, -34.2452, 26.3186, 20.817],
                [34.1767, 38.9553, 26.6687, 27.0403],
                [-28.1, 30.2549, 11.1479, 28.9093],
            ],
            [
                [31.1723, 29.9814, 3.8089, 43.8339],
                [4.8719, -45.0057, 4.9916, -26.8382],
                [3.3817, -10.4425, 22.9996, 19.3862],
            ],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def sres_23112_0():
    data = torch.tensor(
        [
            [[[[11.2379, 20.195]]], [[[10.7906, 2.2899]]], [[[23.6739, 34.2596]]]],
            [[[[46.0481, 22.2038]]], [[[20.0432, 5.6386]]], [[[36.1008, 10.8922]]]],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def sres_234_2():
    data = torch.tensor(
        [
            [
                [-5.689, 6.4527, -4.9591, -3.9225],
                [-6.4398, -7.3402, -5.0251, -5.0951],
                [5.2948, -5.7008, -2.1006, -5.4473],
            ],
            [
                [51.881, 49.8989, 6.3392, 72.954],
                [8.1085, -74.9042, 8.3077, -44.6675],
                [5.6283, -17.3797, 38.279, 32.2649],
            ],
        ],
        dtype=torch.float32,
    )
    return data


@pytest.fixture
def sres_23112_231():
    data = torch.tensor(
        [
            [[[[-5.1327, -9.2237]]], [[[3.9923, 0.8472]]], [[[-35.4812, -51.3464]]]],
            [[[[71.1089, 34.2877]]], [[[-5.5221, -1.5535]]], [[[-48.8875, -14.7501]]]],
        ],
        dtype=torch.float32,
    )
    return data


#######################################################################################################################
