optimizer = {
    'adam': 'torch.optim.Adam',
    'adamw': 'torch.optim.AdamW',
    'rmsprop': 'torch.optim.RMSprop',
    'sgd': 'torch.optim.SGD',
    'lamb': 'src.utils.optim.lamb.JITLamb',
}

scheduler = {
    'constant': 'transformers.get_constant_schedule',
    'plateau': 'torch.optim.lr_scheduler.ReduceLROnPlateau',
    'step': 'torch.optim.lr_scheduler.StepLR',
    'multistep': 'torch.optim.lr_scheduler.MultiStepLR',
    'cosine': 'torch.optim.lr_scheduler.CosineAnnealingLR',
    'constant_warmup': 'transformers.get_constant_schedule_with_warmup',
    'linear_warmup': 'transformers.get_linear_schedule_with_warmup',
    'cosine_warmup': 'transformers.get_cosine_schedule_with_warmup',
}

model = {
    'model': 'src.models.sequence.SequenceModel',
    'unet': 'src.models.sequence.SequenceUNet',
    'lstm': 'src.models.sequence.rnns.lstm.TorchLSTM',
    'ckconv': 'src.models.baselines.ckconv.ClassificationCKCNN',
    'unicornn': 'src.models.baselines.unicornn.UnICORNN',
    'resnet': 'src.models.baselines.resnet.Resnet18Pathfinder',
    'odelstm': 'src.models.baselines.odelstm.ODELSTM',
    'lipschitzrnn': 'src.models.baselines.lipschitzrnn.RnnModels',
    'wavegan': 'src.models.baselines.wavegan.WaveGANDiscriminator',
}

layer = {
    'lstm': 'src.models.sequence.rnns.lstm.TorchLSTM',
    'sru': 'src.models.sequence.rnns.sru.SRURNN', # TODO not updated
    'lssl': 'src.models.sequence.lssl.lssl.LSSL',
    's3': 'src.models.sequence.lssl.s3.StateSpace',
    'ff': 'src.models.sequence.ff.FF',
    'rnn': 'src.models.sequence.rnns.rnn.RNN',
    'mha': 'src.models.sequence.mha.MultiheadAttention',
    'performer': 'src.models.sequence.attention.linear.Performer',
    # 'packedrnn': 'models.sequence.rnns.packedrnn.PackedRNN',
}

callbacks = {
    'timer': 'src.callbacks.timer.Timer',
    'params': 'src.callbacks.params.ParamsLog',
    'learning_rate_monitor': 'pytorch_lightning.callbacks.LearningRateMonitor',
    'model_checkpoint': 'pytorch_lightning.callbacks.ModelCheckpoint',
    'early_stopping': 'pytorch_lightning.callbacks.EarlyStopping',
    'swa': 'pytorch_lightning.callbacks.StochasticWeightAveraging',
    'rich_model_summary': 'pytorch_lightning.callbacks.RichModelSummary',
    'rich_progress_bar': 'pytorch_lightning.callbacks.RichProgressBar',
}
