import collections

HyperParameters = collections.namedtuple('hyperparameters',
                                         ['batch_size',
                                          'noise_dim',
                                          'img_shape',
                                          'num_gens',
                                          'num_classes',
                                          'epochs',
                                          'logdir',
                                          'savedir',
                                          'gen_img_dir',
                                          'gen_lr', 'disc_lr',
                                          'class_lr', 'classifier_mlp',
                                          'beta_1', 'beta_2',
                                          'gp_weight', 'c_loss_weight',
                                          'ep_thres',
                                          'disc_iters_per_gen_iter',
                                          'save_freq', 'save_img_num',
                                          'experiment_name'])

hps = HyperParameters(batch_size=500,
                      noise_dim=128,
                      img_shape=(32, 32, 1),
                      num_gens=5,
                      num_classes=10,
                      epochs=70,
                      logdir='./logs/fit',
                      savedir='./models/',
                      gen_img_dir='./generated_images/',
                      gen_lr=0.0002, disc_lr=0.0002,
                      class_lr=0.001,
                      classifier_mlp=[128, 128],
                      beta_1=0.5, beta_2=0.9,
                      gp_weight=10.0, c_loss_weight=20.0,
                      ep_thres=20,
                      disc_iters_per_gen_iter=3,
                      save_freq=10,
                      save_img_num=4,
                      experiment_name='./classifier')
