# fair-img-gen-dev


## Install (Python 3.8.20)
 
```
pip install -r requirements.txt
```

## Extract 
To extract the features from the prompt, run the following command:

```
python ./src/main.py "protect=[gender]" "extract"
```
Here, `protect` is the protected attribute we want to remove from the prompt's embedding. The names in the brackets are the protected attributes we want to handle. It corresponds to the json files in the `dev` folder.


## Remove
To remove gender/ethnicity from the prompt's embedding, run the following command:

```
python ./src/main.py "protect=[gender]" "remove,prompt=a_firefighter,hdim=600,enoise=0.6"
```
Here, 
- `remove` is the command to remove the protected attribute from the prompt's embedding.
- `hdim` is the number of dimensions of the hidden space we project the prompt's embedding to. Usually, if hdim is small, we remove more protected information but also loss more information.
- `prompt` is the prompt we use to generate the image. Please use underscores instead of spaces.
- `enoise` is the noise level we add back to the prompt's embedding after removing the protected attribute.


## Test multiple prompts
To test multiple prompts, run the following command:

```
python ./src/main.py "data=dev,protect=[gender]" "remove,hdim=800,enoise=1.0"
```

## Multi-Group Fairness
for some demographics like ethnicity, we have multiple groups like white, black, asian, etc. To test multi-group fairness, run the following command:

```
./scripts/run.sh "protect=[ethc]" "extract"
./scripts/run.sh "protect=[ethc]" "remove,hdim=600,prompt=kora_player,enoise=0.7"
```

## Output
The output will be saved as `output/exps/protect=[gender]/combined_image.png`.

## To Do
- [ ] Add more NLP Baseline models
- [ ] Add Evaluation Metrics
- [ ] Add more protected attributes
- [ ] Add more training data in dev. This is important!
- [ ] Add more models like FLUX.1-dev




python ./src/main.py "protect=[gender]" extract > "logs/gender-extract.txt" 2>&1


# fairPCA

python ./src/main.py "protect=[gender]" extract > "logs/gender-extract.txt" 2>&1

python ./src/main.py "protect=[gender]"  "remove,hdim=500,prompt=firefighter,proc=fpca" > "logs/gender-remove-fpca_hdim=500.txt" 2>&1

python ./src/main.py "protect=[gender]"  "remove,hdim=501,prompt=firefighter,proc=fpca,enoise=0.8" > "logs/gender-remove-fpca_hdim-500_enoise-0.8.txt" 2>&1




# SAL
python ./src/main.py "protect=[gender]"  "remove,prompt=firefighter,proc=SAL" > "logs/sal_removal-clamping.txt" 2>&1


python ./src/main.py "protect=[gender]"  "remove,prompt=firefighter,proc=SAL,mean_centering" > "logs/sal_removal-mean.txt" 2>&1


python ./src/main.py "protect=[gender]"  "remove,prompt=firefighter,proc=SAL,enoise=0.01" > "logs/gender-remove-sal-enoise0.01.txt" 2>&1






# Clip-coco

python ./src/main.py "protect=[gender]"  "remove,prompt=firefighter,proc=ClipCoco" > "logs/gender-remove-clipcoco.txt" 2>&1


# Evaluation

python ./src/main.py "data=dev,protect=[gender]" "proc=SAL,remove,mean_centering" > "logs/dev.txt" 2>&1

python ./src/main.py "data=test11,protect=[gender]" "proc=SAL,remove,mean_centering" > "logs/sal_removal-clamping-mean-test11.txt" 2>&1
