# TSTTC for Time-To-Contact estimation.

## Introduction
The TSTTC dataset is a large scale dataset for TTC estimation via monocular images. For more details, please refer to our paper on Openreview.

## Dataset Sturcture

The TSTTC dataset is organized into four main folders: `train`, `val`, `test`, and `nerf`, following the data structure outlined below:


<pre>
TSTTC Dataset
├── train
│ ├── {bag_stamp1}.pkl
│ ├── {bag_stamp1}
│ │ ├── cam1
│ │ │ ├── 16xxxx.jpg
│ │ │ ├── 16xxxx.jpg
│ │ │ └── ...
│ │ ├── cam3
│ │ │ ├── 16xxxx.jpg
│ │ │ ├── 16xxxx.jpg
│ │ │ └── ...
│ │ └── ...
│ └── ...
├── val
│ └── ...
├── test
│ └── ...
└── nerf
  └── ...
</pre>

Within each set, there are multiple bags identified by a unique bag stamp. Each bag consists of up to five camera subfolders: `cam1`, `cam3`, `cam4`, `cam8`, and `cam9`, except for the `nerf` part, which only contains `cam1`. The `cam1`, `cam3`, and `cam4` subfolders correspond to frontal view cameras with different focal lengths, while `cam8` and `cam9` represent backward view cameras. The images within each camera subfolder are named based on the timestamp when they were captured. Additionally, each bag is associated with an annotation file named `bag_stamp.pkl`.

## Annotation Format

The annotation files in the TSTTC dataset are formatted as a list of dictionaries. Each dictionary within the file represents the annotations for a specific camera, with the timestamp serving as the key and the frame annotations as the corresponding value. The frame annotation for each timestamp is represented as a list of objects. Each object is a dictionary containing the following properties:


<pre>
Annotation File (List of Dictionaries)
├── Dict 1
│ ├── Timestamp 1
│ │ ├── Object 1
│ │ │ ├── bag_stamp
│ │ │ ├── box2d
│ │ │ ├── cam_id
│ │ │ ├── id
│ │ │ ├── occ_ratio
│ │ │ ├── same_lane
│ │ │ ├── ts
│ │ │ ├── box_3d_lidar (Not available in test set)
│ │ │ └── ttc_imu (Not available in test set)
│ │ ├── Object 2
│ │ │ ├── ...
│ │ ├── ...
│ ├── Timestamp 2
│ │ ├── ...
│ ├── ...
├── Dict 2
│ ├── ...
├── ...
</pre>

Here is a detailed description of each property:

| Property        | Description                                                                                                                |
|-----------------|----------------------------------------------------------------------------------------------------------------------------|
| bag_stamp       | A string representing the bag stamp of the object, indicating its association with a particular bag within the dataset.    |
| box2d           | A list of floats representing the 2D bounding box of the object in the image. In (x1,y1,x2,y2) format and coordinates are normalized to 0~1 |
| cam_id          | An identifier for the camera to which the object belongs.                                                                 |
| id              | An integer representing the tracking ID of the object across all cameras.                                                |
| occ_ratio       | A float value denoting the occlusion ratio of the object in the 2D images.                                               |
| same_lane       | A boolean flag indicating whether the object is in the same lane as the ego vehicle.                                     |
| ts              | An integer representing the timestamp of the object.                                                                     |
| ttc_imu         | A float value representing the ground truth Time-to-Collision (TTC) of the object. Not available in the test set.         |

Please note that the property `ttc_imu` is not available in the test set, as mentioned in the dataset description. 
