export CUDA_VISIBLE_DEVICES=7
  accelerate launch \
  --config_file gpu7.yaml \
  train_unconditional.py \
  --dataset_name="uoft-cs/cifar10" \
  --resolution=32 --random_flip \
  --output_dir="/data/baek/ddpm/hp_tuning/mux2-cifar10_727_gpu7" \
  --train_batch_size=512 \
  --num_epochs=10000 \
  --checkpointing_steps=10000 \
  --checkpoints_total_limit=3 \
  --gradient_accumulation_steps=1 \
  --use_ema \
  --learning_rate=5e-4 \
  --lr_warmup_steps=200 \
  --mixed_precision=no \
  --logger="wandb" \
  --K=2 \
  --lr_scheduler="cosine_with_restarts" \
  --adam_beta1=0.9 \

  # export CUDA_VISIBLE_DEVICES=2
  # accelerate launch \
  # --config_file gpu2.yaml \
  # train_unconditional.py \
  # --dataset_name="uoft-cs/cifar10" \
  # --resolution=32 --random_flip \
  # --output_dir="/data/baek/ddpm/hp_tuning/mux2-cifar10_726_gpu2" \
  # --train_batch_size=512 \
  # --num_epochs=10000 \
  # --checkpointing_steps=10000 \
  # --checkpoints_total_limit=3 \
  # --gradient_accumulation_steps=1 \
  # --use_ema \
  # --learning_rate=5e-4 \
  # --lr_warmup_steps=200 \
  # --mixed_precision=no \
  # --logger="wandb" \
  # --K=2 \
  # --lr_scheduler="cosine_with_restarts" \
  # --adam_beta1=0.9 \
  # --mux_mod="nonlinear-expand-more" \

  # export CUDA_VISIBLE_DEVICES=3
  # accelerate launch \
  # --config_file gpu3.yaml \
  # train_unconditional.py \
  # --dataset_name="uoft-cs/cifar10" \
  # --resolution=32 --center_crop --random_flip \
  # --output_dir="/data/baek/ddpm/hp_tuning/mux2-cifar10_727_gpu3" \
  # --train_batch_size=64 \
  # --num_epochs=10000 \
  # --checkpointing_steps=50000 \
  # --checkpoints_total_limit=3 \
  # --gradient_accumulation_steps=1 \
  # --use_ema \
  # --learning_rate=2e-4 \
  # --lr_warmup_steps=1000 \
  # --mixed_precision=no \
  # --logger="wandb" \
  # --lr_scheduler="constant" \
  # --K=4 \

# accelerate launch train_unconditional.py \
#   --dataset_name="huggan/flowers-102-categories" \
#   --resolution=64 --center_crop --random_flip \
#   --output_dir="/data/minkyu/ddpm/muxk4-ddpm-ema-flowers-64" \
#   --train_batch_size=16 \
#   --num_epochs=5000 \
#   --checkpointing_steps=5000 \
#   --checkpoints_total_limit=3 \
#   --gradient_accumulation_steps=1 \
#   --use_ema \
#   --learning_rate=1e-4 \
#   --lr_warmup_steps=500 \
#   --mixed_precision=no \
#   --logger="wandb" \
#   --K=4 \
  # --prediction_type="sample" \
  # --mux_mod='linear' \
  # --resume_from_checkpoint="/data/minkyu/ddpm/k2mux-ddpm-ema-flowers-64/checkpoint-51000" \




# accelerate launch --mixed_precision="fp16" --multi_gpu train_unconditional.py \
# export CUDA_VISIBLE_DEVICES=3
#   accelerate launch \
#   --config_file gpu3.yaml \
#   train_unconditional.py \
#   --dataset_name="uoft-cs/cifar10" \
#   --resolution=32 --center_crop --random_flip \
#   --output_dir="/data/minkyu/ddpm/nosilu-mux4-cifar10" \
#   --train_batch_size=128 \
#   --num_epochs=10000 \
#   --checkpointing_steps=50000 \
#   --checkpoints_total_limit=3 \
#   --gradient_accumulation_steps=1 \
#   --use_ema \
#   --learning_rate=2e-4 \
#   --lr_warmup_steps=500 \
#   --mixed_precision=no \
#   --logger="wandb" \
#   --K=4 \
#   --nosilu=Y\
#   --lr_scheduler="constant" \
  # --resume_from_checkpoint="/data/minkyu/ddpm/mux4-cifar10/checkpoint-100000" \

  # --dataset_name="mattymchen/celeba-hq" \
  # --resolution=256 --center_crop --random_flip \
  # --output_dir="/data/minkyu/ddpm/mattymchen/celeba-hq-256" \