# Flow matching examples

## Image

[Flow matching on images.](image/) Pixel space image generation using continuous flow matching.

## Text

[Flow matching on text.](text/) Text generation using discrete flow matching.

## Notebooks

| Notebook | Description |
| --- | --- |
| [standalone_flow_matching.ipynb](standalone_flow_matching.ipynb) | A concise flow matching example built in pure PyTorch. |
| [standalone_discrete_flow_matching.ipynb](standalone_discrete_flow_matching.ipynb) | A concise discrete flow matching example built in pure PyTorch. |
| [2d_flow_matching.ipynb](2d_flow_matching.ipynb) | 2D flow matching example on the checkerboard dataset using the flow_matching library. |
| [2d_discrete_flow_matching.ipynb](2d_discrete_flow_matching.ipynb) | 2D discrete flow matching example on the checkerboard dataset using the flow_matching library. |
| [2d_riemannian_flow_matching_flat_torus.ipynb](2d_riemannian_flow_matching_flat_torus.ipynb) | 2D Riemannian flow matching on a flat torus on the checkerboard dataset and the flow_matching library. |
| [2d_riemannian_flow_matching_sphere.ipynb](2d_riemannian_flow_matching_sphere.ipynb) | 2D Riemannian flow matching on a sphere on the checkerboard dataset and the flow_matching library. |

