import os
import numpy as np
from PIL import Image
from tqdm import tqdm

# 이미지가 저장된 디렉토리 경로
image_dir = '/data/baek/hybrid/cifar10/52525_ddim_50_2/pil'  # 필요시 경로 변경

# PNG 파일 목록 가져오기
image_files = sorted([f for f in os.listdir(image_dir) if f.endswith('.png')])

# 이미지 개수, 크기 등 설정
num_images = len(image_files)

# numpy 배열 초기화
image = []

# 이미지 로딩
for i, fname in enumerate(tqdm(image_files)):
    img_path = os.path.join(image_dir, fname)
    img = Image.open(img_path)
    image.extend([np.array(img)])
images = np.stack(image, axis=0)
print(f"shape of images: {images.shape}")

# npz로 저장
np.savez('/data/baek/hybrid/cifar10/52525_ddim_50_2/50000_samples.npz', images)